/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHFluidHolder;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipFluidWrapper;
import dev.xkmc.youkaishomecoming.content.item.food.YHFoodItem;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class BucketBottleItem
extends BlockItem {
    protected final IYHFluidHolder fluid;

    public BucketBottleItem(Block block, Item.Properties properties, IYHFluidHolder fluid) {
        super(block, properties);
        this.fluid = fluid;
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        if (ctx.m_43723_() != null && !ctx.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        return super.m_40576_(ctx);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FoodProperties food = this.getFoodProperties(stack, (LivingEntity)player);
        if (food == null || food == SlipBottleItem.NONE || food.m_38749_().isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        Object t;
        ItemStack other = stack.m_41613_() == 1 ? ItemStack.f_41583_ : stack.m_41620_(stack.m_41613_() - 1);
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty() || !((t = handler.get()) instanceof SlipFluidWrapper)) {
            return stack;
        }
        SlipFluidWrapper slip = (SlipFluidWrapper)t;
        FluidStack fluid = slip.getFluid();
        super.m_5922_(stack, level, user);
        slip.getContainer().m_41764_(1);
        slip.setFluid(fluid);
        slip.drain(50, IFluidHandler.FluidAction.EXECUTE);
        if (!other.m_41619_()) {
            stack.m_41784_().m_128359_("BottleMarker", "DISCARD");
            if (user instanceof Player) {
                Player player = (Player)user;
                player.m_150109_().m_150079_(other);
            } else {
                user.m_19983_(other);
            }
            stack.m_41764_(0);
        }
        return slip.getContainer();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)YHLangData.PLACE.get(new Object[0]));
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            YHFoodItem.getFoodEffects(stack, list);
        }
        super.m_7373_(stack, level, list, flag);
    }

    public boolean m_41472_() {
        return true;
    }

    @Nullable
    public FoodProperties m_41473_() {
        return SlipBottleItem.NONE;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        FoodProperties food = this.fluid.asStack(1).getFoodProperties(entity);
        if (food == null || food == SlipBottleItem.NONE) {
            return SlipBottleItem.NONE;
        }
        FoodProperties.Builder builder = new FoodProperties.Builder();
        if (food.m_38747_()) {
            builder.m_38765_();
        }
        for (Pair e : food.m_38749_()) {
            MobEffectInstance ins = (MobEffectInstance)e.getFirst();
            EffectBuilder ans = new EffectBuilder(ins);
            if (ins.m_19544_() == YHEffects.DRUNK.get()) {
                int amp = ins.m_19564_() + 1;
                ans.setDuration(amp * ins.m_19557_() / 5);
                ans.setAmplifier(0);
            } else {
                ans.setDuration(ins.m_19557_() / 5);
            }
            builder.effect(() -> ans.ins, ((Float)e.getSecond()).floatValue());
        }
        return builder.m_38767_();
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (this instanceof BucketBottleItem) {
            return new SlipFluidWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }
}

