/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import dev.xkmc.l2library.serial.ingredients.BaseIngredient;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottleTexture;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottledDrinkSet;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipFluidWrapper;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@SerialClass
public class SlipBottleIngredient
extends BaseIngredient<SlipBottleIngredient> {
    public static final BaseIngredient.Serializer<SlipBottleIngredient> INSTANCE = new BaseIngredient.Serializer(SlipBottleIngredient.class, YoukaisHomecoming.loc("fluid"));
    @SerialClass.SerialField
    public Fluid fluid;

    private static Stream<? extends Ingredient.Value> mapStream(Fluid fluid) {
        if (fluid instanceof YHFluid) {
            YHFluid type = (YHFluid)fluid;
            ItemStack item = type.type.asStack(1);
            if (type.type.bottleSet() != null) {
                SlipFluidWrapper filled = new SlipFluidWrapper(YHItems.SAKE_BOTTLE.asStack());
                filled.setFluid(new FluidStack(fluid, 1000));
                ItemStack flask = filled.getContainer();
                BottleTexture bottleTexture = type.type.bottleSet();
                if (bottleTexture instanceof BottledDrinkSet) {
                    BottledDrinkSet set = (BottledDrinkSet)bottleTexture;
                    return Stream.of(new Ingredient.ItemValue(set.bottle.asStack()), new Ingredient.ItemValue(flask), new Ingredient.ItemValue(item));
                }
                return Stream.of(new Ingredient.ItemValue(flask), new Ingredient.ItemValue(item));
            }
            return Stream.of(new Ingredient.ItemValue(item));
        }
        return Stream.of(new Ingredient.Value[0]);
    }

    public SlipBottleIngredient() {
    }

    public SlipBottleIngredient(Fluid fluid) {
        super(SlipBottleIngredient.mapStream(fluid));
        this.fluid = fluid;
    }

    protected SlipBottleIngredient validate() {
        return new SlipBottleIngredient(this.fluid);
    }

    public boolean test(ItemStack stack) {
        Fluid fluid = this.fluid;
        if (!(fluid instanceof YHFluid)) {
            return false;
        }
        YHFluid type = (YHFluid)fluid;
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_150930_(type.type.m_5456_())) {
            return true;
        }
        if (!SlipBottleItem.isSlipContainer(stack)) {
            return false;
        }
        return SlipBottleItem.getFluid(stack).getFluid() == this.fluid;
    }

    public BaseIngredient.Serializer<SlipBottleIngredient> getSerializer() {
        return INSTANCE;
    }
}

