/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import dev.xkmc.youkaishomecoming.content.item.fluid.FluidColorHelper;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipFluidWrapper;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.item.food.YHDrinkItem;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class SlipBottleItem
extends YHDrinkItem {
    public static final FoodProperties NONE = new FoodProperties.Builder().m_38767_();

    public static boolean isSlipContainer(ItemStack stack) {
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        return handler.isPresent() && handler.get() instanceof SlipFluidWrapper;
    }

    public static ItemStack drain(ItemStack stack) {
        Object t;
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty() || !((t = handler.get()) instanceof SlipFluidWrapper)) {
            return stack;
        }
        SlipFluidWrapper slip = (SlipFluidWrapper)t;
        slip.drain(50, IFluidHandler.FluidAction.EXECUTE);
        return slip.getContainer();
    }

    public static ItemStack getContentStack(ItemStack stack) {
        Object t;
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty() || !((t = handler.get()) instanceof SlipFluidWrapper)) {
            return ItemStack.f_41583_;
        }
        SlipFluidWrapper slip = (SlipFluidWrapper)t;
        Fluid fluid = slip.getFluid().getFluid();
        if (fluid instanceof YHFluid) {
            YHFluid fluid2 = (YHFluid)fluid;
            return fluid2.type.asStack(slip.getFluid().getAmount() / 50);
        }
        return ItemStack.f_41583_;
    }

    public SlipBottleItem(Item.Properties builder) {
        super(builder);
    }

    public boolean m_41472_() {
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return super.m_7626_(stack);
        }
        return YHLangData.FLASK_OF.get(fluid.getDisplayName());
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FoodProperties food = this.getFoodProperties(stack, (LivingEntity)player);
        if (food == null || food == NONE || food.m_38749_().isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Nullable
    public FoodProperties m_41473_() {
        return NONE;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty()) {
            return NONE;
        }
        FluidStack fluid = ((IFluidHandlerItem)handler.get()).getFluidInTank(0);
        if (fluid.isEmpty()) {
            return NONE;
        }
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 instanceof YHFluid) {
            YHFluid sake = (YHFluid)fluid2;
            FoodProperties food = sake.type.m_5456_().m_7968_().getFoodProperties(entity);
            if (food == null) {
                return NONE;
            }
            FoodProperties.Builder builder = new FoodProperties.Builder();
            if (food.m_38747_()) {
                builder.m_38765_();
            }
            for (Pair e : food.m_38749_()) {
                MobEffectInstance ins = (MobEffectInstance)e.getFirst();
                EffectBuilder ans = new EffectBuilder(ins);
                if (ins.m_19544_() == YHEffects.DRUNK.get()) {
                    int amp = ins.m_19564_() + 1;
                    ans.setDuration(amp * ins.m_19557_() / 5);
                    ans.setAmplifier(0);
                } else {
                    ans.setDuration(ins.m_19557_() / 5);
                }
                builder.effect(() -> ans.ins, ((Float)e.getSecond()).floatValue());
            }
            return builder.m_38767_();
        }
        return NONE;
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        Object t;
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty() || !((t = handler.get()) instanceof SlipFluidWrapper)) {
            return stack;
        }
        SlipFluidWrapper slip = (SlipFluidWrapper)t;
        FluidStack fluid = slip.getFluid();
        super.m_5922_(stack, level, user);
        slip.getContainer().m_41764_(1);
        slip.setFluid(fluid);
        slip.drain(50, IFluidHandler.FluidAction.EXECUTE);
        return slip.getContainer();
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (this instanceof SlipBottleItem) {
            return new SlipFluidWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public static FluidStack getFluid(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Fluid fluid;
        FluidStack fluid2 = SlipBottleItem.getFluid(stack);
        if (!fluid2.isEmpty() && (fluid = fluid2.getFluid()) instanceof YHFluid) {
            YHFluid sake = (YHFluid)fluid;
            list.add((Component)YHLangData.FLASK_CONTENT.get(sake.getFluidType().getDescription()));
            int amount = fluid2.getAmount();
            if (amount % 50 == 0 && amount > 0 && amount < 1000) {
                list.add((Component)YHLangData.FLASK_USE.get(amount / 50, 20));
            }
            if (sake.type.asStack(1).m_41614_()) {
                list.add((Component)YHLangData.FLASK_INFO_DRINK.get(new Object[0]));
            } else {
                list.add((Component)YHLangData.FLASK_INFO_SAUCE.get(new Object[0]));
            }
        } else {
            list.add((Component)YHLangData.FLASK_INFO_DRINK.get(new Object[0]));
            list.add((Component)YHLangData.FLASK_INFO_SAUCE.get(new Object[0]));
        }
        super.m_7373_(stack, level, list, flag);
    }

    public static int color(ItemStack stack, int layer) {
        if (layer != 1) {
            return -1;
        }
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return -1;
        }
        return FluidColorHelper.getColor(fluid);
    }

    public static float texture(ItemStack stack) {
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean m_142522_(ItemStack stack) {
        return !SlipBottleItem.getFluid(stack).isEmpty();
    }

    public int m_142158_(ItemStack stack) {
        return 13 * SlipBottleItem.getFluid(stack).getAmount() / 1000;
    }

    public int m_142159_(ItemStack stack) {
        return -1;
    }
}

