/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.base;

import com.google.common.collect.Lists;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotItem;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.block.entity.inventory.CookingPotItemHandler;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public abstract class BasePotBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntity,
Nameable,
RecipeHolder,
ContainerData {
    public static final int MEAL_DISPLAY_SLOT = 4;
    public static final int CONTAINER_SLOT = 5;
    public static final int OUTPUT_SLOT = 6;
    public static final int INVENTORY_SIZE = 7;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack mealContainerStack = ItemStack.f_41583_;
    private Component customName;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;
    private boolean wasHeated = false;

    public BasePotBlockEntity(BlockEntityType<? extends BasePotBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract RecipeType<? extends BasePotRecipe> getRecipeType();

    public static ItemStack getMealFromItem(ItemStack pot) {
        CompoundTag inventoryTag;
        CompoundTag compound;
        if (pot.m_41720_() instanceof BasePotItem && (compound = pot.m_41737_("BlockEntityTag")) != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(4);
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.cookTime = compound.m_128451_("CookTime");
        this.cookTimeTotal = compound.m_128451_("CookTimeTotal");
        this.mealContainerStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag recipe = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> recipe.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)recipe);
    }

    protected CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getMeal().m_41619_()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(7);
        for (int i = 0; i < 7; ++i) {
            drops.setStackInSlot(i, this.inventory.getStackInSlot(i));
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        return compound;
    }

    public ItemStack addItem(ItemStack stack) {
        boolean sim = this.f_58857_ == null || this.f_58857_.f_46443_;
        return ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)sim);
    }

    public boolean isGridEmpty() {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void popAll() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, BasePotBlockEntity pot) {
        pot.cookingTick(1, false);
    }

    public void cookingTick(int tick, boolean override) {
        BlockPos pos = this.m_58899_();
        if (this.f_58857_ == null) {
            return;
        }
        boolean heated = override || this.isHeated(this.f_58857_, pos);
        boolean change = false;
        if (heated && this.hasInput()) {
            Optional<? extends BasePotRecipe> recipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory));
            if (recipe.isPresent() && this.canCook(recipe.get())) {
                change = this.processCooking(tick, recipe.get());
            } else {
                this.cookTime = 0;
            }
        } else if (this.cookTime > 0 && !this.wasHeated) {
            this.cookTime = Mth.m_14045_((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
        }
        this.wasHeated = override;
        ItemStack meal = this.getMeal();
        if (!meal.m_41619_()) {
            if (!this.doesMealHaveContainer(meal)) {
                this.moveMealToOutput();
                change = true;
            } else if (!this.inventory.getStackInSlot(5).m_41619_()) {
                this.useStoredContainersOnMeal();
                change = true;
            }
        }
        if (change) {
            this.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, HeatableBlockEntity pot) {
        if (pot.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            RandomSource random = level.f_46441_;
            if (random.m_188501_() < 0.2f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                y = (double)pos.m_123342_() + 0.7;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.m_188501_() < 0.05f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                y = (double)pos.m_123342_() + 0.5;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                double motionY = random.m_188499_() ? 0.015 : 0.005;
                level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }

    private Optional<? extends BasePotRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap(this.getRecipeType()).get(this.lastRecipeID)) instanceof BasePotRecipe) {
            if (recipe.m_5818_((Container)inventoryWrapper, this.f_58857_)) {
                return Optional.of((BasePotRecipe)((Object)recipe));
            }
            if (ItemStack.m_41656_((ItemStack)recipe.m_8043_(this.f_58857_.m_9598_()), (ItemStack)this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44015_(this.getRecipeType(), (Container)inventoryWrapper, this.f_58857_))).isPresent()) {
            ResourceLocation newRecipeID = ((BasePotRecipe)((Object)((Optional)recipe).get())).m_6423_();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.cookTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        ItemStack mealStack = this.getMeal();
        return !mealStack.m_41619_() && !this.mealContainerStack.m_41619_() ? this.mealContainerStack : mealStack.getCraftingRemainingItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(BasePotRecipe recipe) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.hasInput()) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        if (resultStack.m_41619_()) {
            return false;
        }
        ItemStack storedMealStack = this.inventory.getStackInSlot(4);
        if (storedMealStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            return false;
        }
        if (storedMealStack.m_41613_() + resultStack.m_41613_() <= this.inventory.getSlotLimit(4)) {
            return true;
        }
        return storedMealStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
    }

    protected boolean processCooking(int tick, BasePotRecipe recipe) {
        if (this.f_58857_ == null) {
            return false;
        }
        this.cookTime += tick;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        ItemStack storedMealStack = this.inventory.getStackInSlot(4);
        if (storedMealStack.m_41619_()) {
            this.inventory.setStackInSlot(4, resultStack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        this.m_6029_((Recipe<?>)recipe);
        int[] consume = recipe.getConsumption(new RecipeWrapper((IItemHandlerModifiable)this.inventory));
        for (int i = 0; i < 4; ++i) {
            if (consume[i] == 0) continue;
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)CookingPotBlock.FACING)).m_122428_();
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)this.f_58858_.m_123342_() + 0.7;
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ItemStack cont = this.inventory.getStackInSlot(i).getCraftingRemainingItem();
                cont.m_41764_(consume[i]);
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)cont, (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(consume[i]);
        }
        return true;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry ent : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)ent.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                BasePotBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, ent.getIntValue(), ((BasePotRecipe)((Object)recipe)).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public boolean isHeated() {
        return this.f_58857_ != null && this.isHeated(this.f_58857_, this.f_58858_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(4);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 7; ++i) {
            if (i == 4) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(4);
        ItemStack outputStack = this.inventory.getStackInSlot(6);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(6, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.inventory.getStackInSlot(4);
        ItemStack containerInputStack = this.inventory.getStackInSlot(5);
        ItemStack outputStack = this.inventory.getStackInSlot(6);
        if (this.isContainerValid(containerInputStack) && outputStack.m_41613_() < outputStack.m_41741_()) {
            int smallerStackCount = Math.min(mealStack.m_41613_(), containerInputStack.m_41613_());
            int mealCount = Math.min(smallerStackCount, mealStack.m_41741_() - outputStack.m_41613_());
            if (outputStack.m_41619_()) {
                containerInputStack.m_41774_(mealCount);
                this.inventory.setStackInSlot(6, mealStack.m_41620_(mealCount));
            } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
                mealStack.m_41774_(mealCount);
                containerInputStack.m_41774_(mealCount);
                outputStack.m_41769_(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().m_41619_()) {
            container.m_41774_(1);
            return this.getMeal().m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.m_41619_() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.m_41619_()) {
            return false;
        }
        return !this.mealContainerStack.m_41619_() ? ItemStack.m_41656_((ItemStack)this.mealContainerStack, (ItemStack)containerItem) : ItemStack.m_41656_((ItemStack)this.getMeal(), (ItemStack)containerItem);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.m_58900_().m_60734_().m_49954_();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public abstract AbstractContainerMenu m_7208_(int var1, Inventory var2, Player var3);

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return side != null && !side.equals((Object)Direction.UP) ? this.outputHandler.cast() : this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 4) {
                    BasePotBlockEntity.this.checkNewRecipe = true;
                }
                BasePotBlockEntity.this.inventoryChanged();
            }
        };
    }

    public int m_6413_(int index) {
        if (index == 0) {
            return this.cookTime;
        }
        if (index == 1) {
            return this.cookTimeTotal;
        }
        return 0;
    }

    public void m_8050_(int index, int value) {
        if (index == 0) {
            this.cookTime = value;
        }
        if (index == 1) {
            this.cookTimeTotal = value;
        }
    }

    public int m_6499_() {
        return 2;
    }
}

