/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.base;

import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2library.serial.recipe.BaseRecipe;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.base.TimedRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@SerialClass
public abstract class TimedRecipeBlockEntity<T extends BaseRecipe<?, T, C>, C extends Container>
extends BaseBlockEntity
implements TickableBlockEntity,
BaseContainerListener {
    @SerialClass.SerialField
    protected int totalTime = 0;
    @SerialClass.SerialField
    protected int recipeProgress = 0;
    @SerialClass.SerialField
    protected ResourceLocation recipeId = null;
    private boolean doRecipeSearch = true;
    private T recipe = null;

    public TimedRecipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract RecipeType<T> getRecipeType();

    protected abstract boolean isEmpty();

    protected abstract boolean shouldStopProcessing(Level var1);

    protected abstract C createContainer();

    protected abstract void finishRecipe(Level var1, T var2);

    protected void animationTick(Level level) {
    }

    public void notifyTile() {
        this.m_6596_();
        this.sync();
        this.doRecipeSearch = true;
    }

    public float inProgress() {
        return this.totalTime == 0 ? 0.0f : Mth.m_14036_((float)(1.0f * (float)this.recipeProgress / (float)this.totalTime), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            if (this.totalTime > 0) {
                if (this.shouldStopProcessing(this.f_58857_)) {
                    if (this.recipeProgress > 0) {
                        --this.recipeProgress;
                    }
                } else {
                    ++this.recipeProgress;
                    this.animationTick(this.f_58857_);
                }
            }
            return;
        }
        if (this.doRecipeSearch) {
            if (!this.isEmpty()) {
                Optional opt = this.f_58857_.m_7465_().m_44015_(this.getRecipeType(), this.createContainer(), this.f_58857_);
                if (opt.isPresent()) {
                    this.recipe = (BaseRecipe)opt.get();
                    this.totalTime = ((TimedRecipe)this.recipe).getProcessTime();
                    if (!((BaseRecipe)this.recipe).id.equals((Object)this.recipeId)) {
                        this.recipeProgress = 0;
                        this.recipeId = ((BaseRecipe)this.recipe).id;
                    } else if (this.recipeProgress > this.totalTime) {
                        this.recipeProgress = this.totalTime - 1;
                    }
                } else {
                    this.recipeId = null;
                    this.recipe = null;
                    this.totalTime = 0;
                    this.recipeProgress = 0;
                }
                this.sync();
            }
            this.doRecipeSearch = false;
        }
        if (this.totalTime > 0) {
            if (this.shouldStopProcessing(this.f_58857_)) {
                if (this.recipeProgress > 0) {
                    --this.recipeProgress;
                }
            } else {
                ++this.recipeProgress;
            }
            if (this.recipeProgress >= this.totalTime) {
                if (this.recipe != null) {
                    this.finishRecipe(this.f_58857_, this.recipe);
                }
                this.recipeProgress = 0;
                this.totalTime = 0;
                this.recipeId = null;
                this.recipe = null;
            }
        }
    }
}

