/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.cooking.core;

import dev.xkmc.l2modularblock.BlockProxy;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleItem;
import dev.xkmc.youkaishomecoming.content.pot.base.TimedRecipeBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.CookingInv;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.CookingItemContainer;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.PotCookingRecipe;
import dev.xkmc.youkaishomecoming.content.pot.cooking.soup.SoupHolder;
import dev.xkmc.youkaishomecoming.content.pot.overlay.IHintableBlock;
import dev.xkmc.youkaishomecoming.content.pot.overlay.InfoTile;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;

@SerialClass
public abstract class CookingBlockEntity
extends TimedRecipeBlockEntity<PotCookingRecipe<?>, CookingInv>
implements BlockContainer,
HeatableBlockEntity,
IHintableBlock,
InfoTile {
    @SerialClass.SerialField
    public final CookingItemContainer items = (CookingItemContainer)new CookingItemContainer(this, 12).setMax(1);
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.items));
    private final SoupHolder soup = new SoupHolder();
    private boolean recheckSoup = true;
    @Nullable
    private Player lastPlayer;

    public CookingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SoupHolder getSoup() {
        return this.soup;
    }

    public abstract Item container();

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            if (this.recheckSoup) {
                this.recheckSoup = false;
                this.soup.recheckSoup(this, this.f_58857_);
            }
            this.soup.tickSoup(this, this.totalTime == 0 ? 0 : this.recipeProgress);
        }
    }

    public void setLastPlayer(Player player) {
        this.lastPlayer = player;
    }

    public boolean tryAddItem(ItemStack stack, boolean simulate) {
        if (this.f_58857_ == null) {
            return false;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        boolean empty = false;
        for (ItemStack e : this.items.getAsList()) {
            if (!e.m_41619_()) {
                list.add(e);
                continue;
            }
            empty = true;
        }
        if (!empty) {
            return false;
        }
        list.add(stack.m_255036_(1));
        CookingInv inv = new CookingInv(this.container(), list, false);
        Optional opt = this.f_58857_.m_7465_().m_44015_((RecipeType)YHBlocks.COOKING_RT.get(), (Container)inv, this.f_58857_);
        if (opt.isEmpty()) {
            return false;
        }
        if (!simulate) {
            this.items.m_19173_(stack.m_255036_(1));
        }
        return true;
    }

    @Override
    protected RecipeType<PotCookingRecipe<?>> getRecipeType() {
        return (RecipeType)YHBlocks.COOKING_RT.get();
    }

    @Override
    protected boolean isEmpty() {
        return this.items.m_7983_();
    }

    @Override
    protected boolean shouldStopProcessing(Level level) {
        return !this.isHeated(level, this.m_58899_());
    }

    @Override
    public CookingInv createContainer() {
        return this.createContainer(true);
    }

    protected CookingInv createContainer(boolean isComplete) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack e : this.items.getAsList()) {
            if (e.m_41619_()) continue;
            list.add(e);
        }
        return new CookingInv(this.container(), list, isComplete);
    }

    @Override
    protected void finishRecipe(Level level, PotCookingRecipe<?> recipe) {
        ItemStack ans = recipe.assemble(this.createContainer(), level.m_9598_());
        Item item = ans.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem block = (BlockItem)item;
            BlockState state = block.m_40614_().m_49966_();
            if (state.m_61138_((Property)BlockProxy.HORIZONTAL_FACING)) {
                state = (BlockState)state.m_61124_((Property)BlockProxy.HORIZONTAL_FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)BlockProxy.HORIZONTAL_FACING)));
            }
            this.items.clear();
            level.m_46597_(this.m_58899_(), state);
        } else {
            this.items.clear();
            Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7494_(), (ItemStack)ans);
            this.notifyTile();
        }
        item = this.lastPlayer;
        if (item instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)item;
            if (this.lastPlayer.m_6084_()) {
                YHCriteriaTriggers.COOKING.m_222618_(sp);
            }
        }
        this.lastPlayer = null;
    }

    public List<Container> getContainers() {
        SimpleContainer copy = new SimpleContainer(this.items.m_6643_());
        for (int i = 0; i < this.items.m_6643_(); ++i) {
            ItemStack stack = this.items.m_8020_(i);
            if (stack.m_41619_() || stack.hasCraftingRemainingItem() || SlipBottleItem.isSlipContainer(stack)) continue;
            copy.m_19173_(stack.m_41777_());
        }
        return List.of(copy);
    }

    public void dumpInventory() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Container e : this.getContainers()) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7494_(), (Container)e);
        }
        this.items.clear();
        this.notifyTile();
        this.lastPlayer = null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static boolean isHeatedPos(Level level, BlockPos pos) {
        BlockState low;
        BlockState down = level.m_8055_(pos.m_7495_());
        if (down.m_204336_(ModTags.HEAT_SOURCES)) {
            return down.m_61138_((Property)BlockStateProperties.f_61443_) ? (Boolean)down.m_61143_((Property)BlockStateProperties.f_61443_) : true;
        }
        if (down.m_204336_(ModTags.HEAT_CONDUCTORS) && (low = level.m_8055_(pos.m_6625_(2))).m_204336_(ModTags.HEAT_SOURCES)) {
            if (low.m_61138_((Property)BlockStateProperties.f_61443_)) {
                return (Boolean)low.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.recheckSoup = true;
    }

    @Override
    @Nullable
    public TileTooltip getImage(boolean shift, BlockHitResult hit) {
        return null;
    }

    @Override
    public List<Component> lines(boolean shift, BlockHitResult hit) {
        if (this.inProgress() > 0.0f) {
            return List.of(YHLangData.COOKING_PROGRESS.get(Math.round(this.inProgress() * 100.0f) + "%"));
        }
        return List.of();
    }

    @Override
    public List<Ingredient> getHints(Level level, BlockPos pos) {
        if (this.inProgress() > 0.0f) {
            return List.of();
        }
        CookingInv cont = this.createContainer(false);
        List recipes = level.m_7465_().m_44056_(this.getRecipeType(), (Container)cont, level);
        ArrayList<Ingredient> ans = new ArrayList<Ingredient>();
        for (PotCookingRecipe e : recipes) {
            ans.addAll(e.getHints(level, cont));
        }
        return ans;
    }
}

