/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.cooking.core;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.CookingBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.cooking.soup.SoupHolder;
import dev.xkmc.youkaishomecoming.util.FluidRenderer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CookingRenderUtil {
    public static void render(Level level, ItemRenderer itemRenderer, CookingBlockEntity be, float pTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay, float height, float margin, float radius) {
        SoupHolder.SoupData s1 = be.getSoup().getNextLayer(pTick);
        if (s1 != null) {
            ResourceLocation t1 = s1.id().m_246208_("block/bowl/soup/");
            FluidRenderer.renderFluidBox(t1, margin += 0.001f, 0.125f, margin, 1.0f - margin, height -= 0.001f, 1.0f - margin, buffer, pose, light, false, s1.color());
        }
        SoupHolder.SoupData s0 = be.getSoup().getCurrentLayer(pTick);
        ResourceLocation t0 = s0.id().m_246208_("block/bowl/soup/");
        FluidRenderer.renderFluidBox(t0, margin -= 0.001f, 0.125f, margin, 1.0f - margin, height += 0.001f, 1.0f - margin, buffer, pose, light, false, s0.color());
        float time = (pTick + (float)((int)(level.m_46467_() % 80L))) / 80.0f;
        float p = (float)Math.sin((double)(time / 80.0f * 2.0f) * Math.PI);
        float h = height + 0.0625f + 0.03125f * p;
        int seed = (int)be.m_58899_().m_121878_();
        Random rand = new Random(new Random(seed).nextLong());
        List<SoupHolder.ItemEntry> toRender = be.getSoup().floatingItems;
        if (toRender.isEmpty()) {
            return;
        }
        float prog = be.getSoup().getProgress(pTick);
        float total = 0.0f;
        for (SoupHolder.ItemEntry e : toRender) {
            total += e.getAmount(prog);
        }
        if ((double)total < 0.01) {
            return;
        }
        float step = 0.0f;
        for (int i = 0; i < toRender.size(); ++i) {
            SoupHolder.ItemEntry entry = toRender.get(i);
            float amount = entry.getAmount(prog);
            float pr1 = (float)Math.sin((double)(time * 2.0f) * Math.PI + (double)rand.nextFloat());
            float pr2 = (float)Math.cos((double)(time * 2.0f) * Math.PI + (double)(rand.nextFloat() * 2.0f) * Math.PI);
            float angle = 360.0f * step / total + rand.nextFloat() * 10.0f * pr1;
            float dist = radius * (1.0f + rand.nextFloat() * 0.25f + 0.25f * pr2);
            step += amount;
            ItemStack item = entry.stack();
            if (item.m_41619_()) continue;
            pose.m_85836_();
            pose.m_252880_(0.5f, h - (1.0f - amount) * 2.0f / 16.0f, 0.5f);
            pose.m_252781_(Axis.f_252436_.m_252977_(angle));
            pose.m_252781_(Axis.f_252529_.m_252977_(70.0f));
            pose.m_252880_(-dist, -dist, 0.0f);
            pose.m_85841_(0.375f, 0.375f, 0.375f);
            itemRenderer.m_269128_(item, ItemDisplayContext.FIXED, light, overlay, pose, buffer, be.m_58904_(), seed + i);
            pose.m_85849_();
        }
    }
}

