/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.cooking.soup;

import dev.xkmc.youkaishomecoming.content.pot.cooking.core.CookingBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.CookingInv;
import dev.xkmc.youkaishomecoming.content.pot.cooking.soup.SoupBaseRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoupHolder {
    private List<SoupBaseRecipe<?>> recipes = new ArrayList();
    public SoupData current = SoupData.DEF;
    public SoupData next = SoupData.DEF;
    public List<ItemEntry> floatingItems = new ArrayList<ItemEntry>();
    private int lastTime = 0;
    private int nextTime = 0;

    public void recheckSoup(CookingBlockEntity be, Level level) {
        CookingInv cont = be.createContainer();
        this.recipes = level.m_7465_().m_44056_((RecipeType)YHBlocks.SOUP_RT.get(), (Container)cont, level);
        this.current = SoupData.DEF;
        this.next = SoupData.DEF;
        this.floatingItems = new ArrayList<ItemEntry>();
        this.nextTime = 0;
    }

    public void tickSoup(CookingBlockEntity be, int time) {
        this.lastTime = time;
        if (time < this.nextTime) {
            return;
        }
        this.nextTime = Integer.MAX_VALUE;
        for (SoupBaseRecipe<?> e : this.recipes) {
            if (e.time <= time) continue;
            this.nextTime = Math.min(this.nextTime, e.time);
        }
        SoupBaseRecipe<?> r0 = this.findSoup(time);
        SoupBaseRecipe<?> r1 = this.findSoup(this.nextTime);
        this.current = r0 == null ? SoupData.DEF : new SoupData(r0.id, r0.color, r0.time);
        this.next = r1 == null || r0 == r1 ? this.current : new SoupData(r1.id, r1.color, r1.time);
        ArrayList<ItemStack> currentItems = new ArrayList<ItemStack>(be.createContainer().list());
        ArrayList<ItemStack> nextItems = new ArrayList<ItemStack>(currentItems);
        if (r0 != null) {
            r0.removeConsumed(currentItems);
            if (r1 != null) {
                r1.removeConsumed(nextItems);
            } else {
                nextItems = currentItems;
            }
        }
        this.floatingItems = new ArrayList<ItemEntry>();
        for (int i = 0; i < currentItems.size(); ++i) {
            if (currentItems.get(i).m_41619_()) {
                this.floatingItems.add(new ItemEntry(ItemStack.f_41583_, 0));
                continue;
            }
            if (r1 != null && nextItems.get(i).m_41619_()) {
                this.floatingItems.add(new ItemEntry(currentItems.get(i), r1.time));
                continue;
            }
            this.floatingItems.add(new ItemEntry(currentItems.get(i), -1));
        }
    }

    @Nullable
    private SoupBaseRecipe<?> findSoup(int time) {
        int max = 0;
        ResourceLocation current = SoupBaseRecipe.DEF;
        SoupBaseRecipe<?> recipe = null;
        for (SoupBaseRecipe<?> e : this.recipes) {
            if (e.time > time) continue;
            if (e.getIngredientCount() > max) {
                max = e.getIngredientCount();
                current = e.id;
                recipe = e;
                continue;
            }
            if (e.getIngredientCount() != max || e.id.compareTo(current) >= 0) continue;
            current = e.id;
            recipe = e;
        }
        return recipe;
    }

    public float getProgress(float pTick) {
        return ((float)this.lastTime + pTick - (float)this.current.time) / (float)(this.next.time - this.current.time);
    }

    public SoupData getCurrentLayer(float pTick) {
        if (this.current == this.next || this.current.time == this.next.time) {
            return this.current;
        }
        float time = this.getProgress(pTick);
        if (time < 0.5f || time > 1.0f) {
            return this.current;
        }
        int rgb = this.current.color & 0xFFFFFF;
        int alpha = this.current.color >> 24 & 0xFF;
        int an = Math.min(alpha, (int)((float)alpha * (2.0f - time * 2.0f)));
        return new SoupData(this.current.id, an << 24 | rgb, 0);
    }

    @Nullable
    public SoupData getNextLayer(float pTick) {
        if (this.current == this.next || this.current.time == this.next.time) {
            return null;
        }
        float time = this.getProgress(pTick);
        if (time > 0.5f || time < 0.0f) {
            return this.next;
        }
        int rgb = this.next.color & 0xFFFFFF;
        int alpha = this.next.color >> 24 & 0xFF;
        int an = Math.min(alpha, (int)((float)alpha * time * 2.0f));
        return new SoupData(this.next.id, an << 24 | rgb, 0);
    }

    public record SoupData(ResourceLocation id, int color, int time) {
        public static final SoupData DEF = new SoupData(SoupBaseRecipe.DEF, -1, 0);
    }

    public record ItemEntry(ItemStack stack, int life) {
        public float getAmount(float time) {
            if (this.stack.m_41619_()) {
                return 0.0f;
            }
            return this.life < 0 ? 1.0f : 1.0f - time;
        }
    }
}

