/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.kettle;

import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2library.base.tile.BaseTank;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.block.variants.LeftClickBlock;
import dev.xkmc.youkaishomecoming.content.pot.base.FluidItemTile;
import dev.xkmc.youkaishomecoming.content.pot.base.TimedRecipeBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleContainer;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleRecipe;
import dev.xkmc.youkaishomecoming.content.pot.overlay.InfoTile;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;

@SerialClass
public class KettleBlockEntity
extends TimedRecipeBlockEntity<KettleRecipe, SimpleContainer>
implements InfoTile,
HeatableBlockEntity,
LeftClickBlock,
FluidItemTile,
BlockContainer {
    @SerialClass.SerialField
    private final KettleContainer items = (KettleContainer)((KettleContainer)new KettleContainer(4).setMax(1)).add(this);
    @SerialClass.SerialField
    public final BaseTank fluids = new BaseTank(1, 1000).add((BaseContainerListener)this);
    @SerialClass.SerialField
    private int heat = 0;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.items));
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluids);

    public KettleBlockEntity(BlockEntityType<KettleBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public RecipeType<KettleRecipe> getRecipeType() {
        return (RecipeType)YHBlocks.KETTLE_RT.get();
    }

    @Override
    protected boolean isEmpty() {
        return this.items.m_7983_();
    }

    @Override
    public BaseTank getFluidHandler() {
        return this.fluids;
    }

    @Override
    public SimpleContainer getItemHandler() {
        return this.items;
    }

    @Override
    protected boolean shouldStopProcessing(Level level) {
        if (this.heat < 1000) {
            return true;
        }
        FluidStack stack = this.fluids.getFluidInTank(0);
        if (stack.getAmount() < 1000) {
            return true;
        }
        return !stack.getFluid().m_205067_(FluidTags.f_13131_);
    }

    @Override
    protected SimpleContainer createContainer() {
        return this.items;
    }

    public List<Container> getContainers() {
        return List.of(this.items);
    }

    @Override
    protected void finishRecipe(Level level, KettleRecipe recipe) {
        this.items.clear();
        this.fluids.set(1, 0, recipe.result.copy());
        this.heat = 0;
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        FluidStack fluid = this.fluids.getFluidInTank(0);
        if (fluid.getFluid().m_205067_(FluidTags.f_13131_)) {
            if (this.heat >= fluid.getAmount()) {
                this.heat = fluid.getAmount();
            } else if (this.isHeated(this.f_58857_, this.m_58899_())) {
                ++this.heat;
            }
        } else {
            this.heat = 0;
        }
        super.tick();
    }

    public void dumpInventory() {
        if (this.f_58857_ == null) {
            return;
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7494_(), (Container)this.items);
        this.notifyTile();
    }

    public void readFromStack(ItemStack stack) {
        try {
            CompoundTag root = stack.m_41783_();
            if (root == null) {
                return;
            }
            if (root.m_128425_("KettleContents", 9)) {
                ListTag list = root.m_128437_("KettleContents", 10);
                for (Tag e : list) {
                    if (!(e instanceof CompoundTag)) continue;
                    CompoundTag c = (CompoundTag)e;
                    this.items.m_19173_(ItemStack.m_41712_((CompoundTag)c));
                }
            }
            if (root.m_128425_("KettleFluid", 10)) {
                this.fluids.set(1, 0, FluidStack.loadFluidStackFromNBT((CompoundTag)root.m_128469_("KettleFluid")));
            }
            this.heat = root.m_128451_("KettleHeat");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean leftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.f_46443_) {
            return true;
        }
        ItemStack stack = state.m_60734_().m_5456_().m_7968_();
        ListTag list = new ListTag();
        for (ItemStack e : this.items.getAsList()) {
            list.add((Object)e.m_41739_(new CompoundTag()));
        }
        this.items.clear();
        stack.m_41700_("KettleContents", (Tag)list);
        stack.m_41700_("KettleFluid", (Tag)this.fluids.getFluidInTank(0).writeToNBT(new CompoundTag()));
        stack.m_41700_("KettleHeat", (Tag)IntTag.m_128679_((int)this.heat));
        level.m_7471_(pos, false);
        if (player.m_21205_().m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
        } else {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public TileTooltip getImage(boolean shift, BlockHitResult hit) {
        return new TileTooltip(this.items.getAsList(), this.fluids.getAsList(), 3, 2);
    }

    @Override
    public List<Component> lines(boolean shift, BlockHitResult hit) {
        FluidStack fluid = this.fluids.getFluidInTank(0);
        if (!fluid.getFluid().m_205067_(FluidTags.f_13131_)) {
            return List.of();
        }
        float prog = this.inProgress();
        if (prog > 0.0f) {
            return List.of(YHLangData.BREWING_PROGRESS.get(Math.round(prog * 100.0f) + "%"));
        }
        return List.of(YHLangData.HEAT_PROGRESS.get(this.heat / 10 + "%"));
    }

    public void heatUp(int val) {
        FluidStack fluid = this.fluids.getFluidInTank(0);
        if (!fluid.getFluid().m_205067_(FluidTags.f_13131_)) {
            this.heat = 0;
            return;
        }
        this.heat = Math.min(fluid.getAmount(), this.heat + val);
    }

    public void prepareforHotWater(int space) {
        FluidStack fluid = this.fluids.getFluidInTank(0);
        if (!fluid.getFluid().m_205067_(FluidTags.f_13131_)) {
            return;
        }
        if (this.heat < fluid.getAmount() && fluid.getAmount() + space > 1000) {
            fluid.setAmount(Math.max(this.heat, 1000 - space));
        }
    }
}

