/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.steamer;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.overlay.InfoTile;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackData;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackInfo;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackItemData;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerItemHandler;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerStates;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;

@SerialClass
public class SteamerBlockEntity
extends BaseBlockEntity
implements BlockContainer,
TickableBlockEntity,
BaseContainerListener,
HeatableBlockEntity,
InfoTile {
    public static final int OUTPUT_RATE = 20;
    public static final int MAX_STACK = 5;
    @SerialClass.SerialField
    public final List<RackData> racks = new ArrayList<RackData>();
    private IItemHandlerModifiable selfHandler;

    public SteamerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            this.animationTick(this.f_58857_);
            return;
        }
        boolean shouldUpdate = this.checkRack();
        if (this.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) {
            shouldUpdate |= this.cook(this.f_58857_);
        }
        if (shouldUpdate) {
            this.notifyTile();
        }
    }

    public void notifyTile() {
        this.selfHandler = null;
        this.sync();
        this.m_6596_();
    }

    private boolean checkRack() {
        RackInfo info = RackInfo.getRackInfo(this.m_58900_());
        if (this.racks.size() == info.racks()) {
            return false;
        }
        while (this.racks.size() > info.racks()) {
            this.racks.remove(this.racks.size() - 1);
        }
        while (this.racks.size() < info.racks()) {
            this.racks.add(new RackData());
        }
        return true;
    }

    private boolean cook(Level level) {
        Pair hi;
        SteamerBlockEntity be;
        Object object;
        ArrayList<SteamerBlockEntity> steamers = new ArrayList<SteamerBlockEntity>();
        steamers.add(this);
        BlockPos pos = this.m_58899_().m_7494_();
        while ((object = level.m_7702_(pos)) instanceof SteamerBlockEntity && (be = (SteamerBlockEntity)object).m_58900_().m_60713_((Block)YHBlocks.STEAMER_RACK.get())) {
            steamers.add(be);
            if (!level.m_151570_(pos = pos.m_7494_()) && steamers.size() < 5) continue;
        }
        ArrayList<Pair> allRacks = new ArrayList<Pair>();
        for (SteamerBlockEntity e : steamers) {
            for (RackData r : e.racks) {
                allRacks.add(Pair.of((Object)e, (Object)r));
                for (RackItemData item : r.list) {
                    if (item == null) continue;
                    item.height = allRacks.size();
                }
            }
        }
        if (allRacks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < allRacks.size() - 1; ++i) {
            Pair lo = (Pair)allRacks.get(i);
            hi = (Pair)allRacks.get(i + 1);
            ((RackData)lo.getSecond()).downwardHeat = ((RackData)hi.getSecond()).downwardHeat;
        }
        Pair last = (Pair)allRacks.get(allRacks.size() - 1);
        ((RackData)last.getSecond()).downwardHeat = RackInfo.isCapped(level, ((SteamerBlockEntity)last.getFirst()).m_58899_()) ? ((RackData)last.getSecond()).upwardHeat : 0.0;
        for (int i = allRacks.size() - 1; i > 0; --i) {
            hi = (Pair)allRacks.get(i);
            Pair lo = (Pair)allRacks.get(i - 1);
            ((RackData)hi.getSecond()).upwardHeat = ((RackData)lo.getSecond()).upwardHeat;
        }
        Pair first = (Pair)allRacks.get(0);
        ((RackData)first.getSecond()).upwardHeat = (Boolean)this.m_58900_().m_61143_((Property)SteamerStates.WATER) != false && this.isHeated(level, this.m_58899_()) ? 20.0 : 0.0;
        for (Pair e : allRacks) {
            ((RackData)e.getSecond()).tick((SteamerBlockEntity)e.getFirst(), level);
        }
        return true;
    }

    private void animationTick(Level level) {
        double z;
        boolean pot;
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        boolean steam = pot = state.m_60713_((Block)YHBlocks.STEAMER_POT.get()) && (Boolean)state.m_61143_((Property)SteamerStates.WATER) != false && this.isHeated(level, pos);
        for (RackData r : this.racks) {
            if (!(r.upwardHeat > 0.0)) continue;
            steam = true;
            break;
        }
        RandomSource random = level.f_46441_;
        if (level.m_46467_() % 2L == 0L && (pot && random.m_188501_() < 0.5f || steam && random.m_188501_() < 0.2f)) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            double motionY = random.m_188499_() ? 0.015 : 0.005;
            level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, (double)pos.m_123342_() + 0.5, z, 0.0, motionY, 0.0);
        }
        if (!pot) {
            return;
        }
        if (random.m_188501_() < 0.2f) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            double y = (double)pos.m_123342_() + 0.7;
            z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void removeRack(Level level, BlockPos pos, int height) {
        this.selfHandler = null;
        RackData rack = this.racks.remove(this.racks.size() - 1);
        rack.popItems(level, pos, height);
        this.sync();
    }

    private IItemHandlerModifiable getSelfHandler() {
        if (this.f_58857_ == null) {
            return new EmptyHandler();
        }
        if (this.selfHandler != null) {
            return this.selfHandler;
        }
        IItemHandlerModifiable[] handlers = new SteamerItemHandler[this.racks.size()];
        for (int i = 0; i < this.racks.size(); ++i) {
            handlers[i] = new SteamerItemHandler(this, this.f_58857_, this.racks.get(i));
        }
        this.selfHandler = new CombinedInvWrapper(handlers);
        return this.selfHandler;
    }

    private IItemHandlerModifiable getCombinedHandler() {
        BlockEntity blockEntity;
        BlockPos npos;
        if (this.f_58857_ == null) {
            return new EmptyHandler();
        }
        if (this.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) {
            SteamerBlockEntity be;
            BlockEntity blockEntity2;
            ArrayList<IItemHandlerModifiable> steamers = new ArrayList<IItemHandlerModifiable>();
            steamers.add(this.getSelfHandler());
            BlockPos pos = this.m_58899_().m_7494_();
            while ((blockEntity2 = this.f_58857_.m_7702_(pos)) instanceof SteamerBlockEntity && (be = (SteamerBlockEntity)blockEntity2).m_58900_().m_60713_((Block)YHBlocks.STEAMER_RACK.get())) {
                steamers.add(be.getSelfHandler());
                if (!this.f_58857_.m_151570_(pos = pos.m_7494_()) && steamers.size() < 5) continue;
            }
            return new CombinedInvWrapper((IItemHandlerModifiable[])steamers.toArray(IItemHandlerModifiable[]::new));
        }
        BlockPos pos = this.m_58899_();
        for (int y = 1; y < 5 && !this.f_58857_.m_151570_(npos = pos.m_6625_(y)) && (blockEntity = this.f_58857_.m_7702_(npos)) instanceof SteamerBlockEntity; ++y) {
            SteamerBlockEntity be = (SteamerBlockEntity)blockEntity;
            if (!be.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) continue;
            return be.getCombinedHandler();
        }
        return this.getSelfHandler();
    }

    public List<Container> getContainers() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (RackData r : this.racks) {
            for (RackItemData e : r.list) {
                if (e == null || e.stack.m_41619_()) continue;
                stacks.add(e.stack);
            }
        }
        return List.of(new SimpleContainer((ItemStack[])stacks.toArray(ItemStack[]::new)));
    }

    @Override
    @Nullable
    public TileTooltip getImage(boolean shift, BlockHitResult hit) {
        if (shift) {
            int h = this.racks.size();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            boolean empty = true;
            for (RackData r : this.racks) {
                for (RackItemData e : r.list) {
                    if (e == null) {
                        list.add(ItemStack.f_41583_);
                    } else {
                        list.add(e.stack);
                    }
                    empty &= e == null;
                }
            }
            if (empty) {
                return null;
            }
            return new TileTooltip(list, List.of(), 4, h);
        }
        int h = RackInfo.ofY(hit);
        if (this.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) {
            h -= 2;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (h >= 0 && h < this.racks.size()) {
            RackData r = this.racks.get(h);
            for (RackItemData e : r.list) {
                if (e == null || e.stack.m_41619_()) continue;
                list.add(e.stack);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return new TileTooltip(list, List.of(), 2, 2);
    }

    @Override
    public List<Component> lines(boolean shift, BlockHitResult hit) {
        SteamerBlockEntity be;
        BlockEntity blockEntity;
        if (this.f_58857_ == null) {
            return List.of();
        }
        if (!this.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) {
            BlockEntity blockEntity2;
            int count = 1;
            BlockPos pos = this.m_58899_().m_7495_();
            while ((blockEntity2 = this.f_58857_.m_7702_(pos)) instanceof SteamerBlockEntity) {
                SteamerBlockEntity be2 = (SteamerBlockEntity)blockEntity2;
                if (be2.m_58900_().m_60713_((Block)YHBlocks.STEAMER_POT.get())) {
                    return be2.lines(shift, hit);
                }
                ++count;
                if (this.f_58857_.m_151570_(pos = pos.m_7495_())) break;
                if (count < 5) continue;
                return List.of();
            }
            return List.of();
        }
        if (!this.isHeated(this.f_58857_, this.m_58899_())) {
            return List.of(YHLangData.STEAMER_NO_HEAT.get(new Object[0]));
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)SteamerStates.WATER)).booleanValue()) {
            return List.of(YHLangData.STEAMER_NO_WATER.get(new Object[0]));
        }
        SteamerBlockEntity top = this;
        int count = 1;
        BlockPos pos = this.m_58899_().m_7494_();
        while ((blockEntity = this.f_58857_.m_7702_(pos)) instanceof SteamerBlockEntity && (be = (SteamerBlockEntity)blockEntity).m_58900_().m_60713_((Block)YHBlocks.STEAMER_RACK.get())) {
            top = be;
            ++count;
            if (this.f_58857_.m_151570_(pos = pos.m_7494_())) break;
            if (count <= 5) continue;
            return List.of(YHLangData.STEAMER_TOO_MANY.get(new Object[0]));
        }
        if (top == this && this.racks.isEmpty()) {
            return List.of(YHLangData.STEAMER_NO_RACK.get(new Object[0]));
        }
        if (!RackInfo.isCapped(this.f_58857_, top.m_58899_())) {
            return List.of(YHLangData.STEAMER_NO_CAP.get(new Object[0]));
        }
        return List.of();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(this::getCombinedHandler).cast();
        }
        return super.getCapability(cap, side);
    }
}

