/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.steamer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.youkaishomecoming.content.block.food.ISteamerContentBlock;
import dev.xkmc.youkaishomecoming.content.item.food.FoodBlockItem;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackData;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackInfo;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackItemData;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerStates;
import dev.xkmc.youkaishomecoming.util.FluidRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;

public class SteamerBlockRenderer
implements BlockEntityRenderer<SteamerBlockEntity> {
    private static final RandomSource RANDOM = RandomSource.m_216335_((long)42L);
    private final ItemRenderer itemRenderer;

    public SteamerBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.m_234447_();
    }

    public void render(SteamerBlockEntity be, float pTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        Item item;
        RackInfo info = RackInfo.getRackInfo(be.m_58900_());
        if (info.pot() && ((Boolean)be.m_58900_().m_61143_((Property)SteamerStates.WATER)).booleanValue()) {
            FluidRenderer.renderWaterBox(0.25f, 0.0625f, 0.25f, 0.75f, 0.4375f, 0.75f, buffer, pose, light, 0);
        }
        if (info.racks() == 0 || be.racks.isEmpty() || info.racks() > be.racks.size()) {
            return;
        }
        RackData rack = be.racks.get(info.racks() - 1);
        if (rack.list[0] != null && (item = rack.list[0].stack.m_41720_()) instanceof FoodBlockItem) {
            FoodBlockItem item2 = (FoodBlockItem)item;
            pose.m_85836_();
            BlockState state = item2.m_40614_().m_49966_();
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
            pose.m_252880_(0.5f, (float)(info.height() * 4 - 3) / 16.0f, 0.5f);
            Block block = item2.m_40614_();
            if (block instanceof ISteamerContentBlock) {
                ISteamerContentBlock block2 = (ISteamerContentBlock)block;
                float width = 16.0f - block2.clearance() * 2.0f;
                float s = 8.0f / width;
                pose.m_85841_(s, s, s);
            }
            pose.m_252880_(-0.5f, 0.0f, -0.5f);
            ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
            PoseStack.Pose mat = pose.m_85850_();
            RANDOM.m_188584_(42L);
            for (RenderType rt : model.getRenderTypes(state, RANDOM, ModelData.EMPTY)) {
                renderer.renderModel(mat, buffer.m_6299_(ForgeHooksClient.getEntityRenderType((RenderType)rt, (boolean)false)), state, model, 1.0f, 1.0f, 1.0f, light, overlay, ModelData.EMPTY, rt);
            }
            pose.m_85849_();
            return;
        }
        int i = (int)be.m_58899_().m_121878_();
        for (int j = 0; j < rack.list.length; ++j) {
            ItemStack stack;
            RackItemData data = rack.list[j];
            if (data == null || (stack = data.stack).m_41619_()) continue;
            pose.m_85836_();
            pose.m_85837_(0.5, ((double)(info.height() * 4) - 2.8) / 16.0, 0.5);
            Direction rot = Direction.m_122407_((int)(j % 4));
            pose.m_252781_(Axis.f_252436_.m_252977_(-rot.m_122435_()));
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float dist = 0.125f;
            float scale = 0.3125f;
            pose.m_252880_(-dist, -dist, 0.0f);
            pose.m_85841_(scale, scale, scale);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, pose, buffer, be.m_58904_(), i + j);
            pose.m_85849_();
        }
    }
}

