/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.item;

import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodModelHelper;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodTableItemHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.item.FoodTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItemManager;
import dev.xkmc.youkaishomecoming.content.pot.table.recipe.CuisineInv;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodTableItem
implements TableItem {
    private final List<ItemStack> contents;
    private final ItemStack current;
    private final FoodTableItemBase base;
    private final ResourceLocation baseId;
    @Nullable
    private final FoodTableItemHolder holder;

    public FoodTableItem(FoodTableItemBase base, ItemStack current) {
        this.base = base;
        this.contents = List.of();
        this.current = current.m_255036_(1);
        this.holder = FoodModelHelper.find(this.current);
        this.baseId = ((ResourceKey)this.current.m_220173_().m_203543_().orElseThrow()).m_135782_();
    }

    public FoodTableItem(FoodTableItemBase base, ItemStack current, FoodTableItemHolder holder, List<ItemStack> contents) {
        this.base = base;
        this.contents = contents;
        this.current = current;
        this.holder = holder;
        this.baseId = ((ResourceKey)this.current.m_220173_().m_203543_().orElseThrow()).m_135782_();
    }

    @Override
    public int getCost(TableItem prev) {
        if (this.holder != null && prev instanceof TableItemManager) {
            return this.holder.count();
        }
        return 1;
    }

    @Override
    public Optional<TableItem> find(Level level, ItemStack stack) {
        if (this.holder == null) {
            return Optional.empty();
        }
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>(this.contents);
        ans.add(stack.m_255036_(1));
        if (!this.base.isValid(level, this.baseId, ans)) {
            return Optional.empty();
        }
        return Optional.of(new FoodTableItem(this.base, this.current, this.holder, ans));
    }

    @Override
    public List<Ingredient> getHints(Level level) {
        return this.base.getHints(level, this.baseId, this.contents);
    }

    @Override
    public Optional<ItemStack> doTransform() {
        return this.contents.isEmpty() ? Optional.of(this.current) : Optional.empty();
    }

    @Override
    public int step() {
        return this.contents.size() + 1;
    }

    @Override
    public Optional<ItemStack> complete(Level level) {
        if (this.contents.isEmpty()) {
            return Optional.of(this.current.m_41777_());
        }
        CuisineInv cont = new CuisineInv(this.baseId, this.contents, 0, true);
        return level.m_7465_().m_44015_((RecipeType)YHBlocks.CUISINE_RT.get(), (Container)cont, level).map(r -> r.m_5874_((Container)cont, level.m_9598_()));
    }

    @Override
    public List<ResourceLocation> getModels() {
        if (this.holder == null) {
            return List.of();
        }
        if (this.contents.isEmpty() || this.holder.base().additional == null) {
            return List.of(this.holder.model().modelLoc());
        }
        ArrayList<ResourceLocation> ans = new ArrayList<ResourceLocation>();
        ans.add(this.holder.model().modelLoc());
        this.holder.base().additional.buildContents(ans, this.contents);
        return ans;
    }
}

