/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.item;

import dev.xkmc.youkaishomecoming.content.pot.table.item.BaseTableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.VariantTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.model.FixedModelHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.model.VariantModelHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.recipe.CuisineInv;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IngredientTableItem
extends BaseTableItem {
    public static final Map<ResourceLocation, IngredientTableItem> FIXED = new ConcurrentHashMap<ResourceLocation, IngredientTableItem>();
    private final TableItem prev;
    private final Lazy<Ingredient> ingredient;
    private final FixedModelHolder model;
    private final int step;
    @Nullable
    private VariantTableItemBase variant;
    @Nullable
    private ResourceLocation id;

    public IngredientTableItem(BaseTableItem prev, Supplier<Ingredient> ingredient, FixedModelHolder model) {
        this.prev = prev;
        this.ingredient = Lazy.of(ingredient);
        this.model = model;
        this.step = prev.step() + 1;
    }

    public Ingredient ingredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int step() {
        return this.step;
    }

    public synchronized VariantTableItemBase asBase(ResourceLocation id) {
        if (this.variant != null) {
            throw new IllegalStateException("Already has a base");
        }
        FixedModelHolder fixedModelHolder = this.model;
        if (!(fixedModelHolder instanceof VariantModelHolder)) {
            throw new IllegalStateException("Variant item requires a variant model");
        }
        VariantModelHolder holder = (VariantModelHolder)fixedModelHolder;
        this.variant = VariantTableItemBase.create(this, id, holder);
        return this.variant;
    }

    public ResourceLocation getId() {
        if (this.id == null) {
            throw new IllegalStateException("Not an exported model");
        }
        return this.id;
    }

    public ResourceLocation register() {
        String[] strs = this.model.modelLoc().m_135815_().split("/");
        this.id = this.model.modelLoc().m_247449_(strs[strs.length - 1]);
        FIXED.put(this.id, this);
        return this.id;
    }

    @Override
    public void collectIngredients(List<Ingredient> list) {
        this.prev.collectIngredients(list);
        list.add((Ingredient)this.ingredient.get());
    }

    @Override
    public Optional<TableItem> find(Level level, ItemStack stack) {
        Optional<TableItem> ans = super.find(level, stack);
        if (ans.isPresent()) {
            return ans;
        }
        if (this.variant == null) {
            return Optional.empty();
        }
        return this.variant.find(level, stack);
    }

    @Override
    public Optional<ItemStack> complete(Level level) {
        if (this.id == null) {
            return Optional.empty();
        }
        CuisineInv cont = new CuisineInv(this.id, List.of(), 0, true);
        return level.m_7465_().m_44015_((RecipeType)YHBlocks.CUISINE_RT.get(), (Container)cont, level).map(r -> r.m_5874_((Container)cont, level.m_9598_()));
    }

    @Override
    public List<Ingredient> getHints(Level level) {
        List<Ingredient> ans = super.getHints(level);
        if (this.variant != null) {
            ans.addAll(this.variant.getHints(level));
        }
        return ans;
    }

    @Override
    public List<ResourceLocation> getModels() {
        return List.of(this.model.modelLoc());
    }
}

