/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.custom.forms;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.HomingSpellFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.RingFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.forms.ISpellForm;
import dev.xkmc.youkaishomecoming.content.spell.item.PlayerHolder;
import dev.xkmc.youkaishomecoming.content.spell.mover.CompositeMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class HomingSpellForm
extends ISpellForm<HomingSpellFormData> {
    @SerialClass.SerialField
    private HomingSpellFormData data;
    @SerialClass.SerialField
    private int step;
    @SerialClass.SerialField
    private int tick;

    @Override
    public void init(HomingSpellFormData data) {
        this.data = data;
    }

    @Override
    public boolean tick(Player player) {
        if (this.holder == null) {
            this.holder = new PlayerHolder(player, this.dir, this, null);
        }
        DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir);
        RingFormData form = this.data.form();
        int n = form.branches();
        RandomSource rand = this.holder.random();
        while (this.tick >= this.step * form.delay() && this.step < form.steps()) {
            for (int i = 0; i < n; ++i) {
                double ax = ((double)i - (double)(n - 1) * 0.5) * form.branchAngle() + ((double)this.step - (double)(form.steps() - 1) * 0.5) * form.stepAngle();
                double ay = ((double)this.step - (double)(form.steps() - 1) * 0.5) * form.stepVerticalAngle();
                double rx = (rand.m_188500_() * 2.0 - 1.0) * form.randomizedAngle();
                double ry = (rand.m_188500_() * 2.0 - 1.0) * form.randomizedAngle();
                Vec3 dir = o.rotateDegrees(ax + rx, ay + ry);
                int time = this.data.turnTime();
                ItemDanmakuEntity e = this.data.base().prepare(this.holder, dir, this.data.speed(), time);
                e.mover = new RectMover(this.holder.center(), dir.m_82490_(this.data.speed() * 2.0), dir.m_82490_(-this.data.speed() * 2.0 / (double)time));
                this.holder.shoot(e);
                this.addTicker(new Stage().setup(this.holder.center().m_82549_(dir.m_82490_(this.data.speed() * (double)time)), time));
            }
            ++this.step;
        }
        ++this.tick;
        return this.step >= form.steps() & super.tick(player);
    }

    @SerialClass
    public static class Stage
    extends Ticker<HomingSpellForm> {
        @SerialClass.SerialField
        private Vec3 pos = Vec3.f_82478_;

        private Stage setup(Vec3 pos, int time) {
            this.pos = pos;
            this.tick -= time;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, HomingSpellForm card) {
            super.tick(holder, card);
            if (this.tick <= 0) {
                return false;
            }
            HomingSpellFormData data = card.data;
            Vec3 dir = card.targetPos.m_82546_(this.pos).m_82541_();
            ItemDanmakuEntity e = data.base().prepare(holder, dir, data.speed());
            e.m_146884_(this.pos);
            CompositeMover mover = new CompositeMover();
            int time = data.turnTime();
            mover.add(time, new RectMover(this.pos, Vec3.f_82478_, dir.m_82490_(data.speed() * 2.0 / (double)time)));
            mover.add(20, new RectMover(this.pos.m_82549_(dir.m_82490_(data.speed() * (double)time)), dir.m_82490_(data.speed()), Vec3.f_82478_));
            e.mover = mover;
            holder.shoot(e);
            return true;
        }
    }
}

