/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.CompositeMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RotateMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class DoremiSpell
extends ActualSpellCard {
    @SerialClass.SerialField
    private int cooldown;
    @SerialClass.SerialField
    private int mazeTime;
    @SerialClass.SerialField
    private int madTime;
    @SerialClass.SerialField
    private int groundTime;

    @Override
    public void tick(CardHolder holder) {
        YoukaiEntity e;
        LivingEntity le;
        super.tick(holder);
        boolean onGround = false;
        LivingEntity livingEntity = holder.self();
        if (livingEntity instanceof YoukaiEntity && (le = (e = (YoukaiEntity)livingEntity).m_5448_()) != null) {
            onGround = le.m_20096_();
        }
        if (onGround) {
            ++this.groundTime;
            if (this.groundTime > 20) {
                this.groundTime = 20;
            }
        } else {
            --this.groundTime;
            if (this.groundTime < 0) {
                this.groundTime = 0;
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.mazeTime > 0) {
            --this.mazeTime;
        }
        if (this.madTime > 0) {
            --this.madTime;
        }
        if (this.cooldown <= 100 && this.mazeTime <= 0 && this.groundTime == 20) {
            this.addTicker(new Maze());
            this.mazeTime = 100;
            this.madTime = 160;
            this.cooldown += 180;
            return;
        }
        if (this.madTime <= 0 && (this.groundTime == 0 || this.mazeTime <= 0)) {
            this.addTicker(new Madness());
            this.madTime = 100;
            this.mazeTime = 160;
        }
    }

    @SerialClass
    public static class Maze
    extends Ticker<DoremiSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private double init;

        @Override
        public boolean tick(CardHolder holder, DoremiSpell card) {
            super.tick(holder, card);
            if (this.pos == null) {
                this.pos = holder.target();
                this.init = holder.random().m_188500_() * 360.0;
                if (this.pos == null) {
                    return true;
                }
                this.pos = this.pos.m_82520_(0.0, -0.3, 0.0);
                this.laser(holder, 8, 12, 6.0);
            }
            if (this.tick <= 80) {
                this.add(holder, this.pos, 9, 10, 8.0, 0.0);
            }
            this.chase(holder);
            return this.tick > 120;
        }

        private void laser(CardHolder holder, int n, int m, double dist) {
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(new Vec3(1.0, 0.0, 0.0));
            for (int s = -1; s <= 1; s += 2) {
                Vec3 pz = this.pos.m_82520_(0.0, (double)(2 * s), 0.0);
                for (int i = 0; i < n; ++i) {
                    Vec3 pi = pz.m_82549_(o.rotateDegrees(360.0 / (double)n * (double)i).m_82490_(dist));
                    double rand = holder.random().m_188500_() * 360.0;
                    for (int j = 0; j < m; ++j) {
                        Vec3 dir = o.rotateDegrees(360.0 / (double)n * (double)i + 360.0 / (double)m * (double)j + rand);
                        ItemLaserEntity l = holder.prepareLaser(120, pi, dir, 40.0f, YHDanmaku.Laser.LASER, DyeColor.RED);
                        l.mover = new RotateMover(dir, i % 2 == 0 ? 3.0 : -3.0);
                        l.setupTime(0, 0, 100, 20);
                        holder.shoot(l);
                    }
                }
            }
        }

        private void add(CardHolder holder, Vec3 pos, int step, int n, double dist, double tilt) {
            int t0 = 40;
            int t1 = 20;
            double v0 = 0.05;
            double a0 = 0.1;
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(new Vec3(1.0, 0.0, 0.0));
            double angle = this.init + (double)(this.tick * step);
            Vec3 p = pos.m_82549_(o.rotateDegrees(angle, tilt).m_82490_(dist));
            Vec3 dir = o.rotateDegrees(angle, -tilt);
            for (int i = 0; i < n; ++i) {
                int life = 80;
                Vec3 v = DanmakuHelper.getOrientation(dir).rotateDegrees((double)i * 360.0 / (double)n);
                ItemDanmakuEntity e = holder.prepareDanmaku(life, v, YHDanmaku.Bullet.BALL, i % 2 == 0 ? DyeColor.YELLOW : DyeColor.ORANGE);
                CompositeMover m = new CompositeMover();
                e.m_146884_(p);
                m.add(t0, new RectMover(p, v.m_82490_(v0), Vec3.f_82478_));
                m.add(t1, new RectMover(p.m_82549_(v.m_82490_(v0 * (double)t0)), v.m_82490_(v0), v.m_82490_(a0)));
                m.addEnd();
                e.mover = m;
                holder.shoot(e);
            }
        }

        private void chase(CardHolder holder) {
            Vec3 target = holder.target();
            if (target != null && this.tick % 4 == 0 && Math.abs(target.m_7098_() - this.pos.m_7098_() - 0.3) > 2.0) {
                ItemDanmakuEntity e = holder.prepareDanmaku(2, this.pos.m_82546_(target).m_82541_().m_82490_(0.1), YHDanmaku.Bullet.BALL, DyeColor.RED);
                e.m_146884_(target.m_82520_(0.0, -0.3, 0.0));
                holder.shoot(e);
            }
        }
    }

    @SerialClass
    public static class Madness
    extends Ticker<DoremiSpell> {
        @SerialClass.SerialField
        private double[] start;
        @SerialClass.SerialField
        private double[] speed;
        @SerialClass.SerialField
        private double[] freq;
        @SerialClass.SerialField
        private double[] amp;
        @SerialClass.SerialField
        private double[] rot;
        @SerialClass.SerialField
        private double[] r0;

        @Override
        public boolean tick(CardHolder holder, DoremiSpell card) {
            Vec3 target;
            super.tick(holder, card);
            if (this.start == null) {
                int n = 7;
                this.start = new double[n];
                this.speed = new double[n];
                this.freq = new double[n];
                this.amp = new double[n];
                this.rot = new double[n];
                this.r0 = new double[n];
                RandomSource r = holder.random();
                for (int i = 0; i < n; ++i) {
                    this.start[i] = r.m_188500_() * 360.0;
                    this.speed[i] = r.m_188500_() * 2.0 + 2.0;
                    this.amp[i] = r.m_188500_() * 90.0;
                    this.freq[i] = (r.m_188500_() * 20.0 + 10.0) / Math.max(this.amp[i] / 30.0, 1.0);
                    this.rot[i] = r.m_188500_() * 10.0 + 10.0;
                    this.r0[i] = r.m_188500_() * 360.0;
                }
            }
            if ((target = holder.target()) == null) {
                return true;
            }
            int m = 2;
            double dist = 16.0;
            double v = 0.3;
            int n = this.start.length;
            DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(new Vec3(1.0, 0.0, 0.0));
            for (int i = 0; i < n; ++i) {
                Vec3 d0 = o0.rotateDegrees(this.start[i] + this.speed[i] * (double)this.tick, this.amp[i] * (Math.sin(this.freq[i] * (double)this.tick * 0.01745329238474369) / 2.0 + 0.5));
                Vec3 p = target.m_82549_(d0.m_82490_(dist));
                DanmakuHelper.Orientation o1 = DanmakuHelper.getOrientation(d0);
                double r = this.rot[i] * (double)this.tick + this.r0[i];
                for (int j = 0; j < m; ++j) {
                    Vec3 dir = o1.rotateDegrees(360.0 / (double)m * (double)j + r);
                    ItemDanmakuEntity e = holder.prepareDanmaku(100, dir.m_82490_(v), YHDanmaku.Bullet.BALL, j % 2 == 0 ? DyeColor.BLUE : DyeColor.MAGENTA);
                    e.m_146884_(p);
                    holder.shoot(e);
                }
            }
            return this.tick > 100;
        }
    }
}

