/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class LarvaSpell
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        Vec3 dir = holder.forward();
        RandomSource rand = holder.random();
        if (this.tick % 10 == 0) {
            int step = this.tick / 10 % 10;
            if (step <= 2) {
                YoukaiEntity ye;
                LivingEntity te;
                double ver = (rand.m_188500_() * 2.0 - 1.0) * 45.0;
                LivingEntity livingEntity = holder.self();
                if (livingEntity instanceof YoukaiEntity && (te = (ye = (YoukaiEntity)livingEntity).m_5448_()) != null) {
                    if (te.m_20096_()) {
                        ver = rand.m_188500_() * 10.0 - 5.0;
                    } else if (te.m_20184_().f_82480_ > 0.2) {
                        ver = (rand.m_188500_() * 2.0 - 1.0) * 85.0;
                    }
                }
                DanmakuHelper.Orientation nor = DanmakuHelper.getOrientation(dir).asNormal();
                Vec3 n0 = nor.rotateDegrees(ver);
                Vec3 n1 = nor.rotateDegrees(-ver);
                this.addTicker(new Wings().init(dir, n0, 6, 20, 1));
                this.addTicker(new Wings().init(dir, n1, 6, 20, -1));
            } else if (step >= 5 && step <= 8) {
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(dir);
                for (int i = 0; i < 5; ++i) {
                    double vel = 0.65 + (double)i * 0.1;
                    Vec3 vec = o.rotateDegrees((rand.m_188500_() * 2.0 - 1.0) * 3.0, (rand.m_188500_() * 2.0 - 1.0) * 3.0);
                    int life = (int)((double)rand.m_216339_(40, 80) / vel);
                    ItemDanmakuEntity e = holder.prepareDanmaku(life, vec.m_82490_(vel), YHDanmaku.Bullet.BUBBLE, DyeColor.LIME);
                    holder.shoot(e);
                }
            }
        }
        super.tick(holder);
    }

    @SerialClass
    private static class Wings
    extends Ticker<LarvaSpell> {
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);
        @SerialClass.SerialField
        private Vec3 nor = new Vec3(0.0, 1.0, 0.0);
        @SerialClass.SerialField
        private int n;
        @SerialClass.SerialField
        private int dur;
        @SerialClass.SerialField
        private int s;

        private Wings() {
        }

        public Wings init(Vec3 dir, Vec3 nor, int n, int dur, int s) {
            this.dir = dir;
            this.nor = nor;
            this.n = n;
            this.dur = dur;
            this.s = s;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, LarvaSpell card) {
            super.tick(holder, card);
            double angle = (1.0 - Math.sqrt(1.0 * (double)this.tick / (double)this.dur)) * 180.0 * (double)this.s;
            RandomSource r = holder.random();
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir, this.nor);
            Vec3 dir = o.rotateDegrees(angle, r.m_216339_(-5, 5));
            for (int i = 0; i < this.n; ++i) {
                double vel = 0.3 + (double)i * 0.1;
                int life = (int)((double)r.m_216339_(40, 80) / vel);
                ItemDanmakuEntity e = holder.prepareDanmaku(life, dir.m_82490_(vel), YHDanmaku.Bullet.BALL, DyeColor.LIME);
                holder.shoot(e);
            }
            return this.tick > this.dur;
        }
    }
}

