/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class RemiliaSpell
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        Vec3 dir = holder.forward();
        Vec3 target = holder.target();
        if (target == null) {
            return;
        }
        if (this.tick % 20 == 0) {
            Vec3 vel;
            int step = this.tick / 20;
            double dist = holder.center().m_82554_(target);
            RandomSource rand = holder.random();
            if (step % 5 < 3) {
                double v = Math.max(1.0, dist / 20.0);
                Vec3 nor = DanmakuHelper.getOrientation(dir).asNormal().rotateDegrees((rand.m_188500_() * 2.0 - 1.0) * 60.0);
                double ver = 5.0;
                Vec3 tv = holder.targetVelocity();
                if (tv != null) {
                    ver += Math.min(10.0, tv.m_82553_() * 5.0);
                }
                this.addTicker(new Sweep().init(dir, nor, 180.0, 15.0, ver, v * 0.8, v * 1.2, 20, (int)(15.0 * v), (int)Math.max(60.0, dist * 2.0)));
            }
            if (step % 5 == 3 && (vel = holder.targetVelocity()) != null && vel.m_82553_() > 1.0) {
                this.addTicker(new Lasers().init(20, 4, 3, 25, 40, 140));
            }
            if (step % 5 == 4 && dist >= 40.0) {
                this.shootSpear(holder, target, dir);
            }
        }
    }

    private void shootSpear(CardHolder holder, Vec3 target, Vec3 dir) {
        RandomSource rand = holder.random();
        LivingEntity self = holder.self();
        Vec3 tar = holder.center().m_165921_(target, 0.5);
        BlockHitResult hit = self.m_9236_().m_45547_(new ClipContext(holder.center(), tar, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)self));
        if (hit.m_6662_() == HitResult.Type.MISS) {
            self.m_20219_(tar);
        } else {
            self.m_20219_(holder.center().m_165921_(hit.m_82450_(), 0.9));
        }
        double dist = holder.center().m_82554_(target);
        int n = (int)Math.max(100.0, dist * 5.0);
        DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(dir).asNormal();
        for (int i = 0; i < n; ++i) {
            double p = 1.0 * (double)i / (double)n;
            double dr = rand.m_188500_() * p * (1.0 - p) * 4.0 * Math.max(1.0, dist / 20.0);
            Vec3 pos = holder.center().m_165921_(target, p * 1.2).m_82549_(o.rotateDegrees(rand.m_188500_() * 360.0).m_82490_(dr));
            ItemDanmakuEntity e = holder.prepareDanmaku(30, dir.m_82490_(3.0), YHDanmaku.Bullet.MENTOS, DyeColor.RED);
            e.m_146884_(pos);
            holder.shoot(e);
        }
    }

    @SerialClass
    public static class Sweep
    extends Ticker<RemiliaSpell> {
        @SerialClass.SerialField
        private Vec3 dir;
        @SerialClass.SerialField
        private Vec3 nor;
        @SerialClass.SerialField
        private double initialAngle;
        @SerialClass.SerialField
        private double horSpread;
        @SerialClass.SerialField
        private double verSpread;
        @SerialClass.SerialField
        private double lowSpeed;
        @SerialClass.SerialField
        private double highSpeed;
        @SerialClass.SerialField
        private int duration;
        @SerialClass.SerialField
        private int count;
        @SerialClass.SerialField
        private int range;

        public Sweep init(Vec3 dir, Vec3 nor, double initialAngle, double horSpread, double verSpread, double lowSpeed, double highSpeed, int duration, int count, int range) {
            this.dir = dir;
            this.nor = nor;
            this.initialAngle = initialAngle;
            this.horSpread = horSpread;
            this.verSpread = verSpread;
            this.lowSpeed = lowSpeed;
            this.highSpeed = highSpeed;
            this.duration = duration;
            this.count = count;
            this.range = range;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, RemiliaSpell card) {
            double a0 = this.initialAngle + 360.0 / (double)this.duration * (double)this.tick;
            RandomSource rand = holder.random();
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir, this.nor);
            for (int i = 0; i < this.count; ++i) {
                double a1 = a0 + this.horSpread * (rand.m_188500_() * 2.0 - 1.0);
                double a2 = this.verSpread * rand.m_188583_();
                double v0 = this.lowSpeed + (this.highSpeed - this.lowSpeed) * rand.m_188500_();
                int t = (int)Math.ceil((double)this.range / v0 * (1.0 + rand.m_188500_() * 0.1));
                Vec3 d = o.rotateDegrees(a1, a2);
                ItemDanmakuEntity e = holder.prepareDanmaku(t, d.m_82490_(v0), YHDanmaku.Bullet.BUBBLE, DyeColor.RED);
                holder.shoot(e);
                double mid = 0.6 + 0.3 * rand.m_188500_();
                e = holder.prepareDanmaku((int)((double)t / mid * 0.8), d.m_82490_(v0 * mid), YHDanmaku.Bullet.MENTOS, DyeColor.RED);
                holder.shoot(e);
                double low = 0.3 + 0.3 * rand.m_188500_();
                e = holder.prepareDanmaku((int)((double)t / low * 0.6), d.m_82490_(v0 * low), YHDanmaku.Bullet.BALL, DyeColor.RED);
                holder.shoot(e);
            }
            super.tick(holder, card);
            return this.tick > this.duration;
        }
    }

    @SerialClass
    public static class Lasers
    extends Ticker<RemiliaSpell> {
        @SerialClass.SerialField
        public int duration;
        @SerialClass.SerialField
        public int count;
        @SerialClass.SerialField
        public int spread;
        @SerialClass.SerialField
        public int minLen;
        @SerialClass.SerialField
        public int maxLen;
        @SerialClass.SerialField
        public int life;

        public Lasers init(int duration, int count, int spread, int minLen, int maxLen, int life) {
            this.duration = duration;
            this.count = count;
            this.spread = spread;
            this.minLen = minLen;
            this.maxLen = maxLen;
            this.life = life;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, RemiliaSpell card) {
            RandomSource rand = holder.random();
            Vec3 cen = holder.center();
            for (int i = 0; i < this.count; ++i) {
                Vec3 dir = new Vec3(rand.m_188583_(), rand.m_188583_(), rand.m_188583_()).m_82541_();
                int len = rand.m_216339_(this.minLen, this.maxLen);
                ItemLaserEntity l0 = holder.prepareLaser(this.life, cen, dir, len, YHDanmaku.Laser.LASER, DyeColor.LIGHT_BLUE);
                l0.setupTime(10, 10, this.life, 10);
                holder.shoot(l0);
                Vec3 pos = cen.m_82549_(dir.m_82490_((double)len));
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(dir).asNormal();
                double angle = rand.m_188500_() * 360.0;
                for (int j = 0; j < this.spread; ++j) {
                    Vec3 dst = o.rotateDegrees(angle + (double)(j * 120), 45.0);
                    ItemLaserEntity l1 = holder.prepareLaser(this.life, pos, dst, 80.0f, YHDanmaku.Laser.LASER, DyeColor.LIGHT_BLUE);
                    l0.setupTime(20, 10, this.life, 10);
                    holder.shoot(l1);
                }
            }
            super.tick(holder, card);
            return this.tick > this.duration;
        }
    }
}

