/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class StarSpell
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        Vec3 target = holder.forward();
        if (this.tick % 10 == 0 && this.tick / 10 % 6 < 4) {
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(target);
            double x = holder.random().m_188583_() * 20.0;
            double y = holder.random().m_188583_() * 5.0;
            Vec3 vec = o.rotateDegrees(x, y);
            this.addTicker(new ShootingStar(holder.center(), vec));
        }
        super.tick(holder);
    }

    @SerialClass
    public static class ShootingStar
    extends Ticker<StarSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 dir;

        public ShootingStar() {
        }

        public ShootingStar(Vec3 pos, Vec3 vec) {
            this.pos = pos;
            this.dir = vec;
        }

        @Override
        public boolean tick(CardHolder holder, StarSpell card) {
            if (this.dir == null) {
                return true;
            }
            if (this.tick == 0) {
                ItemDanmakuEntity e = holder.prepareDanmaku(60, this.dir.m_82490_(0.8), YHDanmaku.Bullet.MENTOS, DyeColor.RED);
                holder.shoot(e);
            }
            if (this.tick >= 2) {
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir).asNormal();
                Vec3 p = this.pos.m_82549_(this.dir.m_82490_(0.8 * (double)this.tick - 0.4));
                for (int i = 0; i < 2; ++i) {
                    double x = holder.random().m_188500_() * 360.0;
                    double y = holder.random().m_188583_() * 10.0;
                    Vec3 vec = o.rotateDegrees(x, y).m_82490_(0.4);
                    ItemDanmakuEntity e = holder.prepareDanmaku(80, vec, YHDanmaku.Bullet.SPARK, DyeColor.BLUE);
                    e.m_146884_(p);
                    holder.shoot(e);
                }
            }
            super.tick(holder, card);
            return this.tick > 60;
        }
    }
}

