/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.player;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class ReimuItemSpell
extends ItemSpell {
    @Override
    public void start(Player player, @Nullable LivingEntity target) {
        super.start(player, target);
        this.addTicker(new StateChange());
        this.addTicker(new StateChange().setTime(-20));
        this.addTicker(new StateChange().setTime(-40));
    }

    @SerialClass
    public static class StateChange
    extends Ticker<ReimuItemSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 init;
        @SerialClass.SerialField
        private Vec3 normal;
        @SerialClass.SerialField
        private Vec3 target1;
        @SerialClass.SerialField
        private int r0 = 8;
        @SerialClass.SerialField
        private int r1 = 6;
        @SerialClass.SerialField
        private int n = 20;
        @SerialClass.SerialField
        private int t0 = 20;
        @SerialClass.SerialField
        private int t1 = 20;
        @SerialClass.SerialField
        private int t2 = 40;
        @SerialClass.SerialField
        private int dt = 20;
        @SerialClass.SerialField
        private double termSpeed = 1.0;
        @SerialClass.SerialField
        private YHDanmaku.Bullet bullet = YHDanmaku.Bullet.CIRCLE;
        @SerialClass.SerialField
        private DyeColor color = DyeColor.RED;

        @Override
        public boolean tick(CardHolder holder, ReimuItemSpell card) {
            this.step(holder);
            super.tick(holder, card);
            return this.tick > this.t0 + this.t1;
        }

        public StateChange setTime(int time) {
            this.tick = time;
            return this;
        }

        private void step(CardHolder holder) {
            Vec3 vec;
            int i;
            double acc;
            DanmakuHelper.Orientation o0;
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            RandomSource r = holder.random();
            if (this.init == null) {
                this.pos = holder.center();
                Vec3 dir = le.m_82546_(holder.center()).m_82541_();
                this.init = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, 0.0);
                this.normal = dir.m_82537_(this.init);
            }
            if (this.tick < 0) {
                return;
            }
            if (this.tick == 0) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                acc = (double)this.r0 * 2.0 / (double)this.t0 / (double)this.t0;
                for (i = 0; i < this.n; ++i) {
                    Vec3 front = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 vec2 = front.m_82490_(acc * (double)this.t0);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t0, vec2, this.bullet, DyeColor.LIGHT_GRAY);
                    e.mover = new RectMover(this.pos, vec2, front.m_82490_(-acc));
                    holder.shoot(e);
                }
            }
            if (this.tick == this.t0) {
                this.target1 = le;
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                acc = (double)this.r1 * 2.0 / (double)this.t1 / (double)this.t1;
                for (i = 0; i < this.n; ++i) {
                    Vec3 f0 = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 p0 = this.pos.m_82549_(f0.m_82490_((double)this.r0));
                    Vec3 f1 = this.target1.m_82546_(p0).m_82541_();
                    vec = f1.m_82490_(acc * (double)this.t1);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t1, vec, this.bullet, DyeColor.PURPLE);
                    e.m_146884_(p0);
                    e.mover = new RectMover(p0, vec, f1.m_82490_(-acc));
                    holder.shoot(e);
                }
            }
            if (this.tick == this.t0 + this.t1) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                for (int i2 = 0; i2 < this.n; ++i2) {
                    Vec3 f0 = o0.rotateDegrees(360.0 / (double)this.n * (double)i2);
                    Vec3 p0 = this.pos.m_82549_(f0.m_82490_((double)this.r0));
                    Vec3 f1 = this.target1.m_82546_(p0).m_82541_();
                    Vec3 p1 = p0.m_82549_(f1.m_82490_((double)this.r1));
                    Vec3 f2 = le.m_82546_(p1).m_82541_();
                    vec = f2.m_82490_(this.termSpeed);
                    int t = this.t2 + r.m_188503_(this.dt);
                    ItemDanmakuEntity e = holder.prepareDanmaku(t, vec, this.bullet, this.color);
                    e.m_146884_(p1);
                    e.mover = new RectMover(p1, vec, Vec3.f_82478_);
                    holder.shoot(e);
                }
            }
        }
    }
}

