/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.shooter;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.youkaishomecoming.content.spell.shooter.BaseHealthEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ProjectileHealthEntity
extends BaseHealthEntity {
    protected ProjectileHealthEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public abstract int lifetime();

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= this.lifetime()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_6074_();
            }
        } else {
            this.projectileMove();
            if (!this.m_9236_().m_5776_() && !this.m_9236_().m_7232_(this.m_20183_().m_123341_() >> 4, this.m_20183_().m_123343_() >> 4)) {
                this.m_146870_();
            }
        }
    }

    protected void projectileMove() {
        ProjectileMovement movement = this.updateVelocity(this.m_20184_(), this.m_20182_());
        this.m_20256_(movement.vec());
        this.updateRotation(movement.rot());
        double d2 = this.m_20185_() + movement.vec().f_82479_;
        double d0 = this.m_20186_() + movement.vec().f_82480_;
        double d1 = this.m_20189_() + movement.vec().f_82481_;
        this.m_6034_(d2, d0, d1);
    }

    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        return ProjectileMovement.of(vec);
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.m_20334_(pX, pY, pZ);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = Math.sqrt(pX * pX + pZ * pZ);
            this.m_146926_((float)(-(Mth.m_14136_((double)pY, (double)d0) * 57.2957763671875)));
            this.m_146922_((float)(-(Mth.m_14136_((double)pX, (double)pZ) * 57.2957763671875)));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public Vec3 rot() {
        return new Vec3((double)(this.m_146909_() * ((float)Math.PI / 180)), (double)(this.m_146908_() * ((float)Math.PI / 180)), 0.0);
    }

    protected void updateRotation(Vec3 rot) {
        this.m_146926_(ProjectileHealthEntity.lerpRotation(this.f_19860_, (float)(rot.f_82479_ * 57.2957763671875)));
        this.m_146922_(ProjectileHealthEntity.lerpRotation(this.f_19859_, (float)(rot.f_82480_ * 57.2957763671875)));
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }
}

