/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.shooter;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleHolder;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.spell.mover.DanmakuMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverInfo;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverOwner;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ProjectileHealthEntity;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterData;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.LivingCardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class ShooterEntity
extends ProjectileHealthEntity
implements LivingCardHolder,
SpellCircleHolder,
MoverOwner {
    @SerialClass.SerialField
    private ShooterData data = ShooterData.EMPTY;
    @SerialClass.SerialField
    @Nullable
    public DanmakuMover mover = null;
    @Nullable
    private LivingEntity target;
    @SerialClass.SerialField
    @Nullable
    private SpellCard spellCard;

    public ShooterEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public void setup(@Nullable LivingEntity owner, @Nullable LivingEntity target, ShooterData data, SpellCard card) {
        this.setOwner((Entity)owner);
        this.target = target;
        this.data = data;
        this.spellCard = card;
        AttributeInstance ins = this.m_21051_(Attributes.f_22276_);
        if (ins != null) {
            ins.m_22100_((double)data.health());
        }
    }

    @Override
    public TraceableEntity asTraceable() {
        return this;
    }

    @Override
    public int lifetime() {
        return this.data.life();
    }

    public void m_6140_() {
        if (this.spellCard != null && this.m_6084_()) {
            this.spellCard.tick(this);
        }
    }

    @Override
    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        if (this.mover != null) {
            return this.mover.move(new MoverInfo(this.f_19797_, pos, vec, this));
        }
        return super.updateVelocity(vec, pos);
    }

    @Override
    public boolean shouldShowSpellCircle() {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getSpellCircle() {
        return this.data.circle();
    }

    @Override
    public float getCircleSize(float pTick) {
        if (this.f_19797_ < 20) {
            return Mth.m_14036_((float)(((float)this.f_19797_ + pTick) / 20.0f), (float)0.0f, (float)1.0f);
        }
        if (this.f_20919_ > 0) {
            return Mth.m_14036_((float)(((float)(20 - this.f_20919_) + pTick) / 20.0f), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    @Override
    public LivingEntity self() {
        return this;
    }

    @Override
    public LivingEntity shooter() {
        ShooterEntity shooterEntity;
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            shooterEntity = le;
        } else {
            shooterEntity = this;
        }
        return shooterEntity;
    }

    @Override
    @Nullable
    public LivingEntity targetEntity() {
        return this.target;
    }

    @Override
    public float getDamage(YHDanmaku.IDanmakuType type) {
        return this.data.damage();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this)));
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)nbt.m_128469_("auto-serial"), this.getClass(), (Object)this, f -> true));
        }
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)this);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        PacketCodec.from((FriendlyByteBuf)additionalData, this.getClass(), (Object)((ShooterEntity)Wrappers.cast((Object)this)));
    }
}

