/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.youkaishomecoming.init.registrate.YHWorldGen;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class FlatStructure
extends Structure {
    public static final Codec<FlatStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(i -> i.group((App)FlatStructure.m_226567_((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(e -> e.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(e -> e.maxDepth), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(e -> e.useExpansionHack), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(e -> e.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)128).fieldOf("flat_check_range").forGetter(e -> e.flatCheckRange), (App)Codec.intRange((int)1, (int)128).fieldOf("height_tolerance").forGetter(e -> e.flatTolerance)).apply((Applicative)i, FlatStructure::new)), FlatStructure::verifyRange).codec();
    public final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;
    private final boolean useExpansionHack;
    private final int maxDistanceFromCenter;
    private final int flatCheckRange;
    private final int flatTolerance;

    private static DataResult<FlatStructure> verifyRange(FlatStructure s) {
        int i = switch (s.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return s.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)s));
    }

    public FlatStructure(Structure.StructureSettings p_227627_, Holder<StructureTemplatePool> p_227628_, int p_227630_, boolean p_227632_, int p_227634_, int flatCheckRange, int flatTolerance) {
        super(p_227627_);
        this.startPool = p_227628_;
        this.maxDepth = p_227630_;
        this.useExpansionHack = p_227632_;
        this.maxDistanceFromCenter = p_227634_;
        this.flatCheckRange = flatCheckRange;
        this.flatTolerance = flatTolerance;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
        ChunkPos chunkpos = ctx.f_226628_();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iz = -1; iz <= 1; ++iz) {
                int x = ctx.f_226628_().m_151390_() + ix * this.flatCheckRange;
                int z = ctx.f_226628_().m_151393_() + iz * this.flatCheckRange;
                int y = ctx.f_226622_().m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, ctx.f_226629_(), ctx.f_226624_());
                if (y < min) {
                    min = y;
                }
                if (y > max) {
                    max = y;
                }
                if (y <= ctx.f_226622_().m_6337_()) {
                    return Optional.empty();
                }
                Holder biome = ctx.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z), ctx.f_226624_().m_224579_());
                if (this.m_226559_().m_203333_(biome)) continue;
                return Optional.empty();
            }
        }
        if (min + this.flatTolerance < max) {
            return Optional.empty();
        }
        int i = (max + min) / 2;
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), i, chunkpos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)ctx, this.startPool, Optional.empty(), (int)this.maxDepth, (BlockPos)blockpos, (boolean)this.useExpansionHack, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)YHWorldGen.FLAT.get();
    }
}

