/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.events;

import com.tterrag.registrate.util.entry.EntityEntry;
import dev.xkmc.youkaishomecoming.content.entity.boss.BossYoukaiEntity;
import dev.xkmc.youkaishomecoming.content.entity.reimu.MaidenEntity;
import dev.xkmc.youkaishomecoming.content.entity.reimu.ReimuEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.GeneralYoukaiEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.KoishiHatItem;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.init.data.YHAdvGen;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class ReimuEventHandlers {
    private static List<Villager> getWitness(LivingEntity le, int range, boolean eatFlesh) {
        Level level = le.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel sl = (ServerLevel)level;
        AABB aabb = le.m_20191_().m_82400_((double)range);
        return sl.m_142425_(EntityTypeTest.m_156916_(Villager.class), aabb, e -> e.m_6084_() && !e.m_21023_((MobEffect)YHEffects.HYPNOSIS.get()) && (!eatFlesh || e.m_142582_((Entity)le)));
    }

    public static void triggerReimuResponse(LivingEntity le, int range, boolean eatFlesh) {
        Level level = le.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!le.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        List<Villager> list = ReimuEventHandlers.getWitness(le, range, eatFlesh);
        if (!list.isEmpty()) {
            if (le instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)le;
                if (eatFlesh && (!((Boolean)YHModConfig.COMMON.reimuSummonFlesh.get()).booleanValue() || ReimuEventHandlers.fleshWarn(sp))) {
                    for (Villager e : list) {
                        sl.m_7605_((Entity)e, (byte)13);
                        sl.m_8670_(ReputationEventType.f_26988_, (Entity)le, (ReputationEventHandler)e);
                    }
                    return;
                }
            }
            if (ReimuEventHandlers.trySummonMaidenAttack(sl, le)) {
                list.forEach(GolemSensor::m_26649_);
            }
        }
        for (Villager e : list) {
            sl.m_7605_((Entity)e, (byte)13);
            sl.m_8670_(ReputationEventType.f_26988_, (Entity)le, (ReputationEventHandler)e);
        }
    }

    public static boolean koishiBlockReimu(LivingEntity le) {
        KoishiHatItem hat = (KoishiHatItem)((Object)YHItems.KOISHI_HAT.get());
        if (le instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)le;
            if (le.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)hat) && !sp.m_36335_().m_41519_((Item)hat)) {
                EffectEventHandlers.removeKoishi(le);
                sp.m_36335_().m_41524_((Item)hat, 1200);
                sp.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100));
                sp.m_240418_((Component)YHLangData.KOISHI_REIMU.get(new Object[0]), true);
                return true;
            }
        }
        return false;
    }

    public static boolean fleshWarn(ServerPlayer sp) {
        if (ReimuEventHandlers.koishiBlockReimu((LivingEntity)sp)) {
            return true;
        }
        Advancement adv = sp.f_8924_.m_129889_().m_136041_(YHAdvGen.FLESH_WARN);
        if (adv == null || sp.m_8960_().m_135996_(adv).m_8193_()) {
            return false;
        }
        YHCriteriaTriggers.FLESH_WARN.m_222618_(sp);
        sp.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100));
        sp.m_240418_((Component)YHLangData.REIMU_FLESH.get(new Object[0]), true);
        return true;
    }

    public static void hurtWarn(ServerPlayer sp) {
        if (!sp.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (ReimuEventHandlers.getWitness((LivingEntity)sp, 16, false).isEmpty()) {
            return;
        }
        if (ReimuEventHandlers.koishiBlockReimu((LivingEntity)sp)) {
            return;
        }
        Advancement adv = sp.f_8924_.m_129889_().m_136041_(YHAdvGen.HURT_WARN);
        if (adv == null || sp.m_8960_().m_135996_(adv).m_8193_()) {
            return;
        }
        YHCriteriaTriggers.HURT_WARN.m_222618_(sp);
        sp.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100));
        sp.m_240418_((Component)YHLangData.REIMU_WARN.get(new Object[0]), true);
    }

    @Nullable
    public static BossYoukaiEntity trySummonMaiden(ServerLevel sl, LivingEntity le) {
        ReimuEntity e;
        Object type = YHEntities.REIMU;
        if (ModList.get().isLoaded("touhou_little_maid") && (double)le.m_217043_().m_188501_() > 0.5) {
            type = (double)le.m_217043_().m_188501_() > 0.5 ? YHEntities.SANAE : YHEntities.MARISA;
        }
        if ((e = ReimuEventHandlers.trySummon(type, sl, le, 5, 5)) == null) {
            return null;
        }
        ((GeneralYoukaiEntity)e).initSpellCard();
        sl.m_7967_((Entity)e);
        return e;
    }

    @Nullable
    public static <T extends BossYoukaiEntity> T trySummon(EntityEntry<T> type, ServerLevel sl, LivingEntity le, int y0, int dy) {
        BlockPos center = BlockPos.m_274446_((Position)le.m_20182_().m_82549_(le.m_20156_().m_82490_(8.0)).m_82520_(0.0, (double)y0, 0.0));
        BossYoukaiEntity e = (BossYoukaiEntity)type.create((Level)sl);
        if (e == null) {
            return null;
        }
        if (!ReimuEventHandlers.setRandomizedPos(le, e, center, dy)) {
            return null;
        }
        return (T)e;
    }

    private static boolean trySummonMaidenAttack(ServerLevel sl, LivingEntity le) {
        ServerPlayer sp;
        if (le instanceof ServerPlayer && (sp = (ServerPlayer)le).m_7500_()) {
            return false;
        }
        if (ReimuEventHandlers.koishiBlockReimu(le)) {
            return false;
        }
        EffectEventHandlers.removeKoishi(le);
        List list = sl.m_142425_(EntityTypeTest.m_156916_(MaidenEntity.class), le.m_20191_().m_82400_(32.0), LivingEntity::m_6084_);
        if (!list.isEmpty()) {
            for (MaidenEntity e : list) {
                e.m_6710_(le);
                e.refreshIdle();
            }
            return false;
        }
        BossYoukaiEntity maiden = ReimuEventHandlers.trySummonMaiden(sl, le);
        if (maiden == null) {
            return false;
        }
        EffectEventHandlers.removeKoishi(le);
        maiden.m_6710_(le);
        return true;
    }

    public static boolean setRandomizedPos(LivingEntity target, YoukaiEntity youkai, BlockPos center, int dy) {
        BlockPos pos = ReimuEventHandlers.getPosForSpawn(target, youkai, center, 16, 8, dy);
        if (pos == null) {
            center = target.m_20183_().m_6630_(5);
            pos = ReimuEventHandlers.getPosForSpawn(target, youkai, center, 16, 16, dy);
        }
        if (pos == null) {
            return false;
        }
        youkai.m_20035_(pos, 0.0f, 0.0f);
        return true;
    }

    @Nullable
    public static BlockPos getPosForSpawn(LivingEntity target, YoukaiEntity youkai, BlockPos center, int trial, int range, int dy) {
        for (int i = 0; i < trial; ++i) {
            BlockPos pos = center.m_7918_(target.m_217043_().m_216339_(-range, range), target.m_217043_().m_216339_(-dy, dy), target.m_217043_().m_216339_(-range, range));
            youkai.m_20035_(pos, 0.0f, 0.0f);
            if (!target.m_9236_().m_45786_((Entity)youkai) || !youkai.m_142582_((Entity)target)) continue;
            return pos;
        }
        return null;
    }
}

