/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.data;

import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class YHBiomes {
    public static final ResourceKey<Biome> SAKURA_FOREST = YHBiomes.biome("sakura_forest");
    public static final ResourceKey<Biome> SAKURA_TAIGA = YHBiomes.biome("sakura_taiga");
    public static final ResourceKey<Biome> SAKURA_BIRCH_FOREST = YHBiomes.biome("sakura_birch_forest");
    private static final ResourceKey<PlacedFeature> SAKURA_FOREST_CHERRY = YHBiomes.place("sakura_forest_cherry");
    private static final ResourceKey<PlacedFeature> SAKURA_FOREST_OAK = YHBiomes.place("sakura_forest_oak");
    private static final ResourceKey<PlacedFeature> SAKURA_FOREST_BIRCH = YHBiomes.place("sakura_forest_birch");
    private static final ResourceKey<PlacedFeature> SAKURA_FOREST_SPRUCE = YHBiomes.place("sakura_forest_spruce");
    private static final ResourceKey<PlacedFeature> SAKURA_FOREST_PINE = YHBiomes.place("sakura_forest_pine");

    private static ResourceKey<Biome> biome(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)YoukaisHomecoming.loc(id));
    }

    private static ResourceKey<PlacedFeature> place(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)YoukaisHomecoming.loc(id));
    }

    public static void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        HolderGetter freg = ctx.m_255420_(Registries.f_256911_);
        PlacementUtils.m_254943_(ctx, SAKURA_FOREST_CHERRY, (Holder)freg.m_255043_(TreeFeatures.f_271485_), (List)VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.5f, (int)1), (Block)Blocks.f_271334_));
        PlacementUtils.m_254943_(ctx, SAKURA_FOREST_OAK, (Holder)freg.m_255043_(VegetationFeatures.f_195157_), (List)VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)3, (float)0.5f, (int)1)));
        PlacementUtils.m_254943_(ctx, SAKURA_FOREST_BIRCH, (Holder)freg.m_255043_(VegetationFeatures.f_195162_), (List)VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)3, (float)0.5f, (int)1)));
        PlacementUtils.m_254943_(ctx, SAKURA_FOREST_SPRUCE, (Holder)freg.m_255043_(VegetationFeatures.f_195168_), (List)VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.5f, (int)1)));
        PlacementUtils.m_254943_(ctx, SAKURA_FOREST_PINE, (Holder)freg.m_255043_(VegetationFeatures.f_195169_), (List)VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.5f, (int)1)));
    }

    public static void registerBiomes(BootstapContext<Biome> ctx) {
        HolderGetter pfreg = ctx.m_255420_(Registries.f_256988_);
        HolderGetter cwreg = ctx.m_255420_(Registries.f_257003_);
        ctx.m_255272_(SAKURA_FOREST, (Object)YHBiomes.forest((HolderGetter<PlacedFeature>)pfreg, cwreg, SAKURA_FOREST_CHERRY, SAKURA_FOREST_OAK));
        ctx.m_255272_(SAKURA_BIRCH_FOREST, (Object)YHBiomes.forest((HolderGetter<PlacedFeature>)pfreg, cwreg, SAKURA_FOREST_CHERRY, SAKURA_FOREST_BIRCH));
        ctx.m_255272_(SAKURA_TAIGA, (Object)YHBiomes.forest((HolderGetter<PlacedFeature>)pfreg, cwreg, SAKURA_FOREST_PINE, SAKURA_FOREST_SPRUCE));
    }

    @SafeVarargs
    public static Biome forest(HolderGetter<PlacedFeature> pfreg, HolderGetter<ConfiguredWorldCarver<?>> cwreg, ResourceKey<PlacedFeature> ... trees) {
        BiomeGenerationSettings.Builder gen = new BiomeGenerationSettings.Builder(pfreg, cwreg);
        YHBiomes.globalOverworldGeneration(gen);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_283817_);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)gen);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)gen);
        for (ResourceKey<PlacedFeature> tree : trees) {
            gen.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, tree);
        }
        gen.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195423_);
        gen.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195416_);
        gen.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        gen.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_271183_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)gen);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)gen);
        MobSpawnSettings.Builder mob = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mob);
        return YHBiomes.biome(0.7f, 0.8f, mob, gen, music);
    }

    private static Biome biome(float temp, float rain, MobSpawnSettings.Builder mob, BiomeGenerationSettings.Builder gen, @Nullable Music bgm) {
        BiomeSpecialEffects.Builder effs = new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(YHBiomes.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(bgm);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47611_(rain).m_47603_(effs.m_48018_()).m_47605_(mob.m_48381_()).m_47601_(gen.m_255380_()).m_47592_();
    }

    private static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }
}

