/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.youkaishomecoming.content.block.food.BowlBlock;
import dev.xkmc.youkaishomecoming.content.item.food.FleshFoodItem;
import dev.xkmc.youkaishomecoming.content.item.food.YHDrinkItem;
import dev.xkmc.youkaishomecoming.content.item.food.YHFoodItem;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum FoodType {
    SIMPLE(YHFoodItem::new, UnaryOperator.identity(), false, false, new TagKey[0]),
    FAST(YHFoodItem::new, UnaryOperator.identity(), true, false, new TagKey[0]),
    STICK(YHFoodItem::new, p -> p.m_41495_(Items.f_42398_).m_41487_(16), true, false, new TagKey[0]),
    BOWL(YHFoodItem::new, p -> p.m_41495_(Items.f_42399_).m_41487_(16), false, false, new TagKey[0]),
    SAKE(YHDrinkItem::new, p -> p.m_41495_(Items.f_42399_).m_41487_(16), false, true, new TagKey[0]),
    BOTTLE(YHDrinkItem::new, p -> p.m_41495_(Items.f_42590_).m_41487_(16), false, true, new TagKey[0]),
    BAMBOO(YHDrinkItem::new, p -> p.m_41495_(Items.f_41911_).m_41487_(16), false, true, new TagKey[0]),
    BOTTLE_FAST(YHDrinkItem::new, p -> p.m_41495_(Items.f_42590_).m_41487_(16), true, true, new TagKey[0]),
    IRON_BOWL(YHFoodItem::new, p -> p.m_41495_(YHBlocks.IRON_BOWL.m_5456_()).m_41487_(16), false, false, new TagKey[0]),
    BAMBOO_BOWL(YHFoodItem::new, p -> p.m_41495_(Items.f_41911_).m_41487_(16), false, false, new TagKey[0]),
    SAUCER(YHFoodItem::new, p -> p.m_41495_(YHItems.SAUCER.m_5456_()).m_41487_(16), false, false, new TagKey[0]),
    FLESH(FleshFoodItem::new, UnaryOperator.identity(), false, false, YHTagGen.FLESH_FOOD),
    FLESH_FAST(FleshFoodItem::new, UnaryOperator.identity(), true, false, YHTagGen.FLESH_FOOD),
    BOWL_FLESH(FleshFoodItem::new, p -> p.m_41495_(Items.f_42399_).m_41487_(16), false, false, YHTagGen.FLESH_FOOD),
    SAUCER_FLESH(FleshFoodItem::new, p -> p.m_41495_(YHItems.SAUCER.m_5456_()).m_41487_(16), false, false, YHTagGen.FLESH_FOOD),
    CAN_FLESH(FleshFoodItem::new, p -> p.m_41495_((Item)YHItems.CAN.get()).m_41487_(64), true, false, YHTagGen.FLESH_FOOD);

    private final Function<Item.Properties, Item> factory;
    private final UnaryOperator<Item.Properties> prop;
    private final boolean fast;
    private final boolean alwaysEat;
    private final TagKey<Item>[] tags;

    @SafeVarargs
    private FoodType(Function<Item.Properties, Item> factory, UnaryOperator<Item.Properties> prop, boolean fast, boolean alwaysEat, TagKey<Item> ... tags) {
        this.factory = factory;
        this.prop = prop;
        this.fast = fast;
        this.alwaysEat = alwaysEat;
        this.tags = tags;
    }

    public ItemEntry<Item> build(String folder, String name, int nutrition, float sat, TagKey<Item>[] tags, List<EffectEntry> effs) {
        return this.build(this.factory, folder, name, nutrition, sat, tags, effs);
    }

    public ItemEntry<Item> build(Function<Item.Properties, Item> factory, String folder, String name, int nutrition, float sat, TagKey<Item>[] tags, List<EffectEntry> effs) {
        return this.build(factory, name, nutrition, sat, tags, effs).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/" + folder + ctx.getName())})).register();
    }

    public ItemBuilder<Item, L2Registrate> build(String name, int nutrition, float sat, TagKey<Item>[] tags, List<EffectEntry> effs) {
        return this.build(this.factory, name, nutrition, sat, tags, effs);
    }

    public ItemBuilder<Item, L2Registrate> build(Function<Item.Properties, Item> factory, String name, int nutrition, float sat, TagKey<Item>[] tags, List<EffectEntry> effs) {
        return (ItemBuilder)YoukaisHomecoming.REGISTRATE.item(name, p -> (Item)factory.apply(this.food((Item.Properties)p, nutrition, sat, effs))).tag(FoodType.getTags(this.tags, tags)).lang(Item::m_5524_, this.makeLang(name));
    }

    public Item.Properties food(Item.Properties prop, float edibility, int nutrition, float sat, List<EffectEntry> effs) {
        return edibility <= 0.0f ? (Item.Properties)this.prop.apply(prop) : (edibility < 1.0f ? this.food(prop, (int)((float)nutrition * edibility), sat * edibility, List.of()) : this.food(prop, nutrition, sat, effs));
    }

    public Item.Properties food(Item.Properties prop, int nutrition, float sat, List<EffectEntry> effs) {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(sat);
        if (this.fast) {
            food.m_38766_();
        }
        if (this.alwaysEat) {
            food.m_38765_();
        }
        for (EffectEntry e : effs) {
            food.effect(e::getEffect, e.chance());
        }
        return ((Item.Properties)this.prop.apply(prop)).m_41489_(food.m_38767_());
    }

    public BlockBuilder<BowlBlock, L2Registrate> bowl(String name, boolean raw) {
        if (this == IRON_BOWL) {
            return BowlBlock.ironBowlFood(name);
        }
        if (this == BAMBOO_BOWL) {
            return raw ? BowlBlock.rawBambooBowl(name) : BowlBlock.bambooBowl(name);
        }
        return BowlBlock.woodBowlFood(name);
    }

    public String makeLang(String id) {
        String name = YHItems.toEnglishName(id.toLowerCase(Locale.ROOT));
        if (this.isFlesh()) {
            name = name.replaceFirst("Flesh", "%1\\$s");
        }
        return YHItems.toEnglishName(name);
    }

    public boolean isFlesh() {
        return this == FLESH || this == BOWL_FLESH || this == FLESH_FAST || this == CAN_FLESH || this == SAUCER_FLESH;
    }

    private static TagKey<Item>[] getTags(TagKey<Item>[] a, TagKey<Item>[] b) {
        ArrayList<TagKey<Item>> ans = new ArrayList<TagKey<Item>>(List.of(a));
        ans.addAll(List.of(b));
        return (TagKey[])ans.toArray(TagKey[]::new);
    }
}

