/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.compat.diet.DietTagGen;
import dev.xkmc.youkaishomecoming.content.block.food.BowlBlock;
import dev.xkmc.youkaishomecoming.content.item.food.FoodBlockItem;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodRegistryHelper;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum YHBowl implements ItemLike
{
    MISO_SOUP(FoodType.BOWL, 8, 0.5f, new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f), DietTagGen.VEGETABLES.tag),
    SEAFOOD_MISO_SOUP(FoodType.BOWL, 12, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 6000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f)), DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag),
    POOR_GOD_SOUP(FoodType.BOWL, 6, 0.5f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19590_, 3600, 0, 0.3f)), DietTagGen.VEGETABLES.tag),
    HIGAN_SOUP(FoodType.IRON_BOWL, 8, 0.5f, new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f), YHTagGen.IRON_BOWL_FOOD, DietTagGen.VEGETABLES.tag),
    MUSHROOM_SOUP(FoodType.IRON_BOWL, 8, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.VEGETABLES.tag),
    POWER_SOUP(FoodType.IRON_BOWL, 12, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 6000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19600_, 6000, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    POTATO_SOUP(FoodType.IRON_BOWL, 12, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag),
    BORSCHT(FoodType.IRON_BOWL, 8, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.VEGETABLES.tag),
    SIGNATURE_MUSHROOM_STEW(FoodType.IRON_BOWL, 6, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 2000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3000, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.VEGETABLES.tag),
    HOKKAIDO_SALMON_HOTPOT(FoodType.IRON_BOWL, 14, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 6000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19598_, 6000, 0, 1.0f)), YHTagGen.IRON_BOWL_FOOD, DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag, DietTagGen.GRAINS.tag),
    TUTU_CONGEE(FoodType.BAMBOO_BOWL, 8, 0.6f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200, 0, 1.0f)), YHTagGen.STEAM_BLOCKER, YHTagGen.PLACE_WITH_CONTAINER, DietTagGen.VEGETABLES.tag, DietTagGen.GRAINS.tag),
    RICE_POWDER_PORK(FoodType.BAMBOO_BOWL, 14, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000, 0, 1.0f)), YHTagGen.STEAM_BLOCKER, YHTagGen.PLACE_WITH_CONTAINER, DietTagGen.VEGETABLES.tag, DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag),
    KAGUYA_HIME(FoodType.BAMBOO_BOWL, 14, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.SMOOTHING, 3000, 0, 1.0f)), YHTagGen.STEAM_BLOCKER, YHTagGen.PLACE_WITH_CONTAINER, DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag);

    private final String id;
    public final BlockEntry<BowlBlock> raw;
    public final BlockEntry<BowlBlock> item;
    private final FoodType type;

    @SafeVarargs
    private YHBowl(FoodType type, int nutrition, float sat, List<EffectEntry> effs, TagKey<Item> ... tags) {
        this.type = type;
        String name = this.name().toLowerCase(Locale.ROOT);
        this.id = FoodRegistryHelper.getId(type, tags);
        this.raw = type == FoodType.BAMBOO_BOWL ? this.buildBlock("raw_" + name, true, nutrition, sat, effs, tags) : null;
        this.item = this.buildBlock(name, false, nutrition, sat, effs, tags);
    }

    @SafeVarargs
    private YHBowl(FoodType type, int nutrition, float sat, EffectEntry eff, TagKey<Item> ... tags) {
        this(type, nutrition, sat, List.of(eff), tags);
    }

    private BlockEntry<BowlBlock> buildBlock(String name, boolean raw, int nutrition, float sat, List<EffectEntry> effs, TagKey<Item> ... tags) {
        return ((BlockBuilder)this.type.bowl(name, raw).item((block, p) -> new FoodBlockItem((Block)block, this.type.food((Item.Properties)p, raw ? 0.0f : 1.0f, nutrition, sat, effs))).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/" + this.id + ctx.getName())})).tag(tags).build()).register();
    }

    public Item m_5456_() {
        return this.item.m_5456_();
    }

    private boolean isFlesh() {
        return this.type.isFlesh();
    }

    private boolean isUnappealing() {
        return switch (this) {
            case POOR_GOD_SOUP, HIGAN_SOUP -> true;
            default -> false;
        };
    }

    public boolean isReimuFood() {
        return !this.isFlesh() && !this.isUnappealing();
    }

    public static void register() {
    }
}

