/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.compat.diet.DietTagGen;
import dev.xkmc.youkaishomecoming.content.block.food.FoodSaucerBlock;
import dev.xkmc.youkaishomecoming.content.item.food.FleshSaucerItem;
import dev.xkmc.youkaishomecoming.content.item.food.FoodBlockItem;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import dev.xkmc.youkaishomecoming.init.food.Saucer;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum YHDish {
    BAMBOO_MIZUYOKAN(Saucer.CERAMIC, DishType.COOKED, 6, 0.6f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), DietTagGen.VEGETABLES.tag, DietTagGen.SUGARS.tag),
    DRIED_FISH(Saucer.CERAMIC, DishType.COOKED, 8, 0.8f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    IMITATION_BEAR_PAW(Saucer.CERAMIC, DishType.STEAMED, 12, 0.8f, 3, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19600_, 3600, 1, 1.0f), new EffectEntry(() -> MobEffects.f_19606_, 3600, 0, 1.0f)), YHTagGen.STEAM_BLOCKER, DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag),
    PASTITSIO(Saucer.CERAMIC, DishType.COOKED, 12, 0.8f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), DietTagGen.VEGETABLES.tag, DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag),
    SAUCE_GRILLED_FISH(Saucer.PORCELAIN, DishType.COOKED, 12, 0.8f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), DietTagGen.VEGETABLES.tag, DietTagGen.PROTEINS.tag),
    STINKY_TOFU(Saucer.CERAMIC, DishType.COOKED, 8, 0.6f, 5, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    TOFU_BURGER(Saucer.CERAMIC, DishType.COOKED, 8, 0.6f, 3, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    BLOOD_CURD(Saucer.CERAMIC, DishType.COOKED, 8, 0.8f, 2, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    SEVEN_COLORED_YOKAN(Saucer.CERAMIC, DishType.COOKED, 8, 0.8f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.UDUMBARA, 3600, 1, 1.0f)), DietTagGen.VEGETABLES.tag, DietTagGen.GRAINS.tag),
    BLOODY_FLESH(Saucer.CERAMIC, DishType.FLESH, 6, 0.8f, 3, List.of(), YHTagGen.FLESH_FOOD, YHTagGen.APPARENT_FLESH_FOOD, DietTagGen.PROTEINS.tag),
    COLD_TOFU(Saucer.CERAMIC, DishType.COOKED, 8, 0.8f, 4, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    CUMBERLAND_LOIN(Saucer.CERAMIC, DishType.COOKED, 10, 0.8f, 2, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag),
    SCHOLAR_GINKGO(Saucer.CERAMIC, DishType.STEAMED, 6, 0.8f, 2, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f)), YHTagGen.STEAM_BLOCKER, DietTagGen.VEGETABLES.tag),
    TOMATO_SAUCE_COD(Saucer.CERAMIC, DishType.COOKED, 10, 0.8f, 2, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600, 0, 1.0f)), DietTagGen.PROTEINS.tag);

    public final Saucer saucer;
    public final DishType base;
    public final int height;
    public final BlockEntry<FoodSaucerBlock> raw;
    public final BlockEntry<FoodSaucerBlock> block;

    private YHDish(Saucer saucer, DishType type, int nutrition, float sat, int height, List<EffectEntry> effs, TagKey<Item> ... tags) {
        this.saucer = saucer;
        this.base = type;
        this.height = height;
        this.raw = type == DishType.STEAMED ? this.buildBlock("raw_" + this.getName(), true, nutrition, sat, effs, tags) : null;
        this.block = this.buildBlock(this.getName(), false, nutrition, sat, effs, tags);
    }

    private String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private BlockEntry<FoodSaucerBlock> buildBlock(String name, boolean raw, int nutrition, float sat, List<EffectEntry> effs, TagKey<Item> ... tags) {
        return ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block(name, p -> new FoodSaucerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50102_), this)).blockstate((ctx, pvd) -> pvd.horizontalBlock((Block)ctx.get(), (ModelFile)this.buildModel((RegistrateBlockstateProvider)pvd, !raw))).item((block, p) -> this.base.create((FoodSaucerBlock)block, (Item.Properties)p, raw, nutrition, sat, effs)).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/saucer/" + ctx.getName())})).tag(tags).build()).register();
    }

    private BlockModelBuilder buildModel(RegistrateBlockstateProvider pvd, boolean extra) {
        String name = this.getName();
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/dish/" + name)));
        for (String e : this.saucer.tex) {
            builder.texture(e, "block/dish/" + e);
        }
        builder.texture("particle", "block/dish/" + this.saucer.tex[0]);
        builder.texture("base", "block/dish/" + name + "_base");
        if (extra) {
            builder.texture("detail", "block/dish/" + name + "_detail");
        }
        builder.renderType("cutout");
        return builder;
    }

    public boolean isFlesh() {
        return this == BLOOD_CURD || this == BLOODY_FLESH;
    }

    public static void register() {
    }

    public static enum DishType {
        COOKED(FoodType.SAUCER),
        STEAMED(FoodType.SAUCER),
        FLESH(FoodType.SAUCER_FLESH);

        private final FoodType type;

        private DishType(FoodType type) {
            this.type = type;
        }

        public Item create(FoodSaucerBlock block, Item.Properties p, boolean raw, int nutrition, float sat, List<EffectEntry> effs) {
            this.type.food(p, raw ? 0.5f : 1.0f, nutrition, sat, effs);
            if (this.type.isFlesh()) {
                return new FleshSaucerItem(block, p);
            }
            return new FoodBlockItem(block, p);
        }
    }
}

