/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottleTexture;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottledDrinkSet;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottledFluid;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHFluidHolder;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluidType;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum YHDrink implements IYHFluidHolder
{
    GREEN_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.TEA, 1200, 1, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    WHITE_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.REFRESHING, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    BLACK_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.THICK, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    OOLONG_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.MEDITATION, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    DARK_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.SMOOTHING, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    YELLOW_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.BREATHING, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    CORNFLOWER_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry(() -> MobEffects.f_19605_, 200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    TEA_MOCHA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    SAIDI_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry(() -> MobEffects.f_19596_, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    SAKURA_HONEY_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry(() -> MobEffects.f_19596_, 400, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19605_, 400, 0, 1.0f)), YHTagGen.TEA_DRINK),
    GENMAI_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.TEA, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.SOBER, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK),
    SCARLET_TEA(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.THICK, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.YOUKAIFYING, 1200, 0, 1.0f)), YHTagGen.TEA_DRINK, YHTagGen.FLESH_FOOD),
    GREEN_WATER(FoodType.BOTTLE, -1, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.TEA, 600, 0, 0.1f)), YHTagGen.TEA_DRINK),
    MIO(FoodType.BOTTLE, -8875803, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f)), YHTagGen.SAKE),
    MEAD(FoodType.BOTTLE, -268122, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19596_, 1200, 0, 1.0f)), YHTagGen.SAKE),
    SPARROW_SAKE(FoodType.BAMBOO, -1331, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19621_, 1200, 0, 1.0f)), YHTagGen.SAKE),
    KIKU(FoodType.SAKE, -2763080, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f)), YHTagGen.SAKE),
    HAKUTSURU(FoodType.SAKE, -926275, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f)), YHTagGen.SAKE),
    KAPPA_VILLAGE(FoodType.SAKE, -2763080, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19608_, 1200, 0, 0.5f)), YHTagGen.SAKE),
    SUIGEI(FoodType.SAKE, -1836549, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry(() -> MobEffects.f_19608_, 1200, 0, 1.0f)), YHTagGen.SAKE),
    DAIGINJO(FoodType.SAKE, -1325173, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 1, 1.0f), new EffectEntry(() -> MobEffects.f_19600_, 1200, 2, 1.0f)), YHTagGen.SAKE),
    DASSAI(FoodType.SAKE, -5738652, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 1, 1.0f), new EffectEntry(() -> MobEffects.f_19598_, 1200, 2, 1.0f)), YHTagGen.SAKE),
    TENGU_TANGO(FoodType.SAKE, -5412797, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 1, 1.0f), new EffectEntry(() -> MobEffects.f_19596_, 1200, 2, 1.0f)), YHTagGen.SAKE),
    FULL_MOONS_EVE(FoodType.SAKE, -787717, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.UDUMBARA, 1200, 1, 1.0f)), YHTagGen.SAKE),
    SCARLET_MIST(FoodType.BOTTLE, -1414264, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 1, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.YOUKAIFIED, 1200, 0, 1.0f)), YHTagGen.FLESH_FOOD),
    WIND_PRIESTESSES(FoodType.BOTTLE, -8789558, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 1200, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.NATIVE, 600, 0, 1.0f)), YHTagGen.SAKE),
    BLACK_GRAPE_JUICE(FoodType.BOTTLE, -11262404, List.of(), new TagKey[0]),
    RED_GRAPE_JUICE(FoodType.BOTTLE, -6413479, List.of(), new TagKey[0]),
    WHITE_GRAPE_JUICE(FoodType.BOTTLE, -5789838, List.of(), new TagKey[0]),
    RED_WINE(FoodType.BOTTLE, -7132103, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 2000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.EARTHY, 1000, 0, 1.0f)), YHTagGen.WINE),
    WHITE_WINE(FoodType.BOTTLE, -1647687, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 2000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.ENJOYABLE, 1000, 0, 1.0f)), YHTagGen.WINE),
    BURGUNDY(FoodType.BOTTLE, -8774612, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.EARTHY, 1500, 1, 1.0f)), YHTagGen.WINE),
    CHAMPAGNE(FoodType.BOTTLE, -1910863, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.ENJOYABLE, 3000, 0, 1.0f)), YHTagGen.WINE),
    VAN_ALLEN(FoodType.BOTTLE, -6743458, List.of(new EffectEntry((Supplier<MobEffect>)YHEffects.DRUNK, 3000, 0, 1.0f), new EffectEntry((Supplier<MobEffect>)YHEffects.EARTHY, 3000, 0, 1.0f)), YHTagGen.WINE);

    public final int color;
    public final String folder;
    public final FluidEntry<YHFluid> fluid;
    public final ItemEntry<Item> item;
    @Nullable
    public final BottledDrinkSet set;

    @SafeVarargs
    private YHDrink(FoodType type, int color, List<EffectEntry> effs, TagKey<Item> ... tags) {
        this.color = color;
        String name = this.name().toLowerCase(Locale.ROOT);
        this.fluid = BottledFluid.water(name, (p, s, f) -> new YHFluidType(p, s, f, this), p -> new YHFluid((ForgeFlowingFluid.Properties)p, this)).defaultLang().register();
        this.folder = name.contains("tea") || name.contains("water") ? "drink" : (name.contains("juice") || tags.length > 0 && tags[0] == YHTagGen.WINE ? "wine" : "sake");
        this.item = type.build(p -> new SakeBottleItem(() -> this.fluid.getSource(), (Item.Properties)p), "food/" + this.folder + "/", name, 0, 0.0f, tags, effs);
        this.set = tags.length > 0 && tags[0] == YHTagGen.WINE ? new BottledDrinkSet(this) : null;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public ItemEntry<?> item() {
        return this.item;
    }

    @Override
    public Item m_5456_() {
        return this.item.m_5456_();
    }

    @Override
    public YHFluid source() {
        return (YHFluid)this.fluid.getSource();
    }

    @Override
    @Nullable
    public String bottleTextureFolder() {
        return this.folder;
    }

    @Override
    @Nullable
    public BottleTexture bottleSet() {
        return this.set;
    }

    @Override
    public Item getContainer() {
        Item ans = ((Item)this.item.get()).m_41469_();
        if (ans == Items.f_41911_) {
            ans = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("bamboo"));
        }
        if (ans == null) {
            return Items.f_41852_;
        }
        return ans;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ItemStack asStack(int count) {
        return this.item.asStack(count);
    }

    public boolean isFlesh() {
        return this == SCARLET_MIST || this == SCARLET_TEA;
    }

    public static void register() {
    }
}

