/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.serialization.Codec;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHBiomeTagsProvider;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.loot.BiomeTagCondition;
import dev.xkmc.youkaishomecoming.init.loot.RemoveItemModifier;
import dev.xkmc.youkaishomecoming.init.loot.ReplaceItemModifier;
import dev.xkmc.youkaishomecoming.init.loot.YHLootGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import dev.xkmc.youkaishomecoming.mixin.AddItemModifierAccessor;
import dev.xkmc.youkaishomecoming.mixin.AddLootTableModifierAccessor;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.loot.modifier.AddItemModifier;
import vectorwing.farmersdelight.common.tag.ModTags;

public class YHGLMProvider
extends GlobalLootModifierProvider {
    public static final RegistryEntry<Codec<ReplaceItemModifier>> REPLACE_ITEM = YoukaisHomecoming.REGISTRATE.simple("replace_item", ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, () -> ReplaceItemModifier.CODEC);
    public static final RegistryEntry<Codec<RemoveItemModifier>> REMOVE_ITEM = YoukaisHomecoming.REGISTRATE.simple("remove_item", ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, () -> RemoveItemModifier.CODEC);
    public static final RegistryEntry<LootItemConditionType> BIOME_CHECK = YoukaisHomecoming.REGISTRATE.simple("biome_check", Registries.f_256976_, () -> new LootItemConditionType((Serializer)new Serializer<BiomeTagCondition>(){

        public void serialize(JsonObject json, BiomeTagCondition cond, JsonSerializationContext ctx) {
            json.addProperty("tag", cond.tag.f_203868_().toString());
        }

        public BiomeTagCondition deserialize(JsonObject json, JsonDeserializationContext ctx) {
            return new BiomeTagCondition((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.m_135820_((String)json.get("tag").getAsString())));
        }
    }));

    public static void register() {
    }

    public YHGLMProvider(DataGenerator gen) {
        super(gen.getPackOutput(), "youkaishomecoming");
    }

    protected void start() {
        this.add("tuna_hunt", (IGlobalLootModifier)new RemoveItemModifier(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_((EntityType)((EntityType)YHEntities.TUNA.get())))).m_6409_()));
        this.add("scavenging_roe", (IGlobalLootModifier)YHGLMProvider.create((Item)YHFood.ROE.item.get(), 1, YHGLMProvider.killedByKnife(), YHGLMProvider.fire(false), YHGLMProvider.entity(EntityType.f_20519_), LootItemRandomChanceCondition.m_81927_((float)0.5f).m_6409_()));
        this.add("fishing_lamprey", (IGlobalLootModifier)new ReplaceItemModifier(0.1f, YHFood.RAW_LAMPREY.item.asStack(), LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.f_78720_).m_6409_(), new BiomeTagCondition(YHBiomeTagsProvider.LAMPREY)));
        this.add("fishing_crab", (IGlobalLootModifier)new ReplaceItemModifier(0.1f, YHFood.CRAB.item.asStack(), LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.f_78720_).m_6409_(), new BiomeTagCondition(YHBiomeTagsProvider.CRAB_FISHING)));
        this.add("scavenging_flesh", (IGlobalLootModifier)YHGLMProvider.create((Item)YHFood.FLESH.item.get(), 1, YHGLMProvider.killedByKnife(), YHGLMProvider.fire(false), YHGLMProvider.isFleshSource(), YHGLMProvider.killedByYoukai()));
        this.add("scavenging_flesh_cooked", (IGlobalLootModifier)YHGLMProvider.create((Item)YHFood.COOKED_FLESH.item.get(), 1, YHGLMProvider.killedByKnife(), YHGLMProvider.fire(true), YHGLMProvider.isFleshSource(), YHGLMProvider.killedByYoukai()));
        this.add("rumia_scavenging_flesh", (IGlobalLootModifier)YHGLMProvider.create((Item)YHFood.FLESH.item.get(), 1, YHGLMProvider.killedByRumia(), YHGLMProvider.fire(false), YHGLMProvider.isFleshSource()));
        this.add("rumia_scavenging_flesh_cooked", (IGlobalLootModifier)YHGLMProvider.create((Item)YHFood.COOKED_FLESH.item.get(), 1, YHGLMProvider.killedByRumia(), YHGLMProvider.fire(true), YHGLMProvider.isFleshSource()));
        this.add("rumia_scavenging_skeleton_skull", (IGlobalLootModifier)YHGLMProvider.create(Items.f_42678_, 1, YHGLMProvider.killedByRumia(), YHGLMProvider.entity(YHTagGen.SKULL_SOURCE)));
        this.add("rumia_scavenging_wither_skeleton_skull", (IGlobalLootModifier)YHGLMProvider.create(Items.f_42679_, 1, YHGLMProvider.killedByRumia(), YHGLMProvider.entity(YHTagGen.WITHER_SOURCE)));
        this.add("rumia_scavenging_zombie_head", (IGlobalLootModifier)YHGLMProvider.create(Items.f_42681_, 1, YHGLMProvider.killedByRumia(), YHGLMProvider.entity(YHTagGen.ZOMBIE_SOURCE)));
        this.add("rumia_scavenging_creeper_head", (IGlobalLootModifier)YHGLMProvider.create(Items.f_42682_, 1, YHGLMProvider.killedByRumia(), YHGLMProvider.entity(YHTagGen.CREEPER_SOURCE)));
        this.add("rumia_scavenging_piglin_head", (IGlobalLootModifier)YHGLMProvider.create(Items.f_260451_, 1, YHGLMProvider.killedByRumia(), YHGLMProvider.entity(YHTagGen.PIGLIN_SOURCE)));
        this.add("cirno_frozen_frog_cold", (IGlobalLootModifier)YHGLMProvider.create((Item)YHItems.FROZEN_FROG_COLD.get(), 1, YHGLMProvider.killedByCirno(), YHGLMProvider.frog(FrogVariant.f_218187_)));
        this.add("cirno_frozen_frog_warm", (IGlobalLootModifier)YHGLMProvider.create((Item)YHItems.FROZEN_FROG_WARM.get(), 1, YHGLMProvider.killedByCirno(), YHGLMProvider.frog(FrogVariant.f_218186_)));
        this.add("cirno_frozen_frog_temperate", (IGlobalLootModifier)YHGLMProvider.create((Item)YHItems.FROZEN_FROG_TEMPERATE.get(), 1, YHGLMProvider.killedByCirno(), YHGLMProvider.frog(FrogVariant.f_218185_)));
        this.add("udumbara_ancient_city_loot", (IGlobalLootModifier)YHGLMProvider.loot(YHLootGen.UDUMBARA_LOOT, LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.f_230876_).m_6409_()));
        this.add("udumbara_ancient_city_ice_box_loot", (IGlobalLootModifier)YHGLMProvider.loot(YHLootGen.UDUMBARA_LOOT, LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.f_230877_).m_6409_()));
    }

    private static LootModifier loot(ResourceLocation id, LootItemCondition ... cond) {
        return AddLootTableModifierAccessor.createAddLootTableModifier(cond, id);
    }

    private static LootItemCondition isFleshSource() {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_204081_(YHTagGen.FLESH_SOURCE))).m_6409_();
    }

    private static LootItemCondition killer(EntityType<?> type) {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_(type))).m_6409_();
    }

    private static LootItemCondition entity(EntityType<?> type) {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_(type))).m_6409_();
    }

    private static LootItemCondition frog(FrogVariant type) {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217012_).m_218800_(EntitySubPredicate.m_218833_((FrogVariant)type))).m_6409_();
    }

    private static LootItemCondition entity(TagKey<EntityType<?>> tag) {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_204081_(tag))).m_6409_();
    }

    public static LootItemCondition killedByKnife() {
        return LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(ModTags.KNIVES).m_45077_()).m_32207_()).m_36662_()).m_6409_();
    }

    private static LootItemCondition killedByRumia() {
        return LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_32205_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{YHItems.RUMIA_HAIRBAND}).m_45077_()).m_32207_()).m_36662_()).m_6409_();
    }

    private static LootItemCondition killedByCirno() {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_((EntityType)((EntityType)YHEntities.CIRNO.get())))).m_285888_(LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_32205_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)YHItems.CIRNO_HAIRBAND.get()}).m_45077_()).m_32207_()).m_36662_())).m_6409_();
    }

    private static LootItemCondition killedByYoukai() {
        return LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36652_(MobEffectsPredicate.m_56552_().m_56553_((MobEffect)YHEffects.YOUKAIFYING.get()))).m_285888_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36652_(MobEffectsPredicate.m_56552_().m_56553_((MobEffect)YHEffects.YOUKAIFIED.get())))).m_6409_();
    }

    private static LootItemCondition fire(boolean fire) {
        return LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(fire)).m_33716_()).m_36662_()).m_6409_();
    }

    private static AddItemModifier create(Item item, int count, LootItemCondition ... conditions) {
        AddItemModifier ans = AddItemModifierAccessor.create(conditions, item, count);
        assert (ans != null);
        return ans;
    }

    private static <T> EntryHolder<T> vanilla(T obj, String id) {
        return new EntryHolder<T>(obj, new ResourceLocation(id));
    }

    private static <T> EntryHolder<T> of(RegistryObject<T> obj) {
        return new EntryHolder<Object>(obj.get(), obj.getId());
    }

    private static <T> EntryHolder<T> of(RegistryEntry<T> obj) {
        return new EntryHolder<Object>(obj.get(), obj.getId());
    }

    private record EntryHolder<T>(T type, ResourceLocation id) {
    }
}

