/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CompatCore;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundSpeakSoundPacket;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import com.codinglitch.simpleradio.radio.effects.AudioEffect;
import com.codinglitch.simpleradio.radio.effects.BaseAudioEffect;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RadioSpeaker
extends RadioRouter
implements Supplier<short[]> {
    public LocationalAudioChannel audioChannel;
    public AudioPlayer audioPlayer;
    private final Map<UUID, Map<UUID, Queue<short[]>>> packetBuffer = new HashMap<UUID, Map<UUID, Queue<short[]>>>();
    private final Map<UUID, OpusDecoder> decoders = new HashMap<UUID, OpusDecoder>();
    private final AudioEffect effect = new BaseAudioEffect();
    public String category;
    public float range = 8.0f;
    public int speakingTime = 0;

    protected RadioSpeaker(UUID id) {
        super(id);
    }

    protected RadioSpeaker() {
        this(UUID.randomUUID());
    }

    public RadioSpeaker(Entity owner) {
        this(owner, UUID.randomUUID());
    }

    public RadioSpeaker(Entity owner, UUID uuid) {
        this(uuid);
        this.owner = owner;
        RadioManager.registerRouterSided(this, owner.m_9236_().m_5776_(), null);
    }

    public RadioSpeaker(WorldlyPosition location) {
        this(location, UUID.randomUUID());
    }

    public RadioSpeaker(WorldlyPosition location, UUID uuid) {
        this(uuid);
        this.location = location;
        RadioManager.registerRouterSided(this, location.isClientSide(), null);
    }

    public void setRange(float range) {
        this.range = range;
    }

    @Override
    public short[] get() {
        short[] audio = this.generatePacket();
        if (audio == null) {
            if (this.audioPlayer != null) {
                this.audioPlayer.stopPlaying();
            }
            this.audioPlayer = null;
            return null;
        }
        return audio;
    }

    public short[] generatePacket() {
        ArrayList<short[]> totalPacketsToCombine = new ArrayList<short[]>();
        for (Map.Entry<UUID, Map<UUID, Queue<short[]>>> listenerPacket : this.packetBuffer.entrySet()) {
            Map<UUID, Queue<short[]>> playerPackets = listenerPacket.getValue();
            if (playerPackets.isEmpty()) continue;
            ArrayList<short[]> playerPacketsToCombine = new ArrayList<short[]>();
            for (Map.Entry<UUID, Queue<short[]>> playerPacket : playerPackets.entrySet()) {
                short[] audio = playerPacket.getValue().poll();
                if (audio == null) continue;
                playerPacketsToCombine.add(audio);
            }
            playerPackets.values().removeIf(Collection::isEmpty);
            totalPacketsToCombine.add(CommonRadioPlugin.combineAudio(playerPacketsToCombine));
        }
        this.packetBuffer.values().removeIf(Map::isEmpty);
        if (totalPacketsToCombine.isEmpty()) {
            return null;
        }
        return CommonRadioPlugin.combineAudio(totalPacketsToCombine);
    }

    @Override
    public void updateLocation(WorldlyPosition location) {
        super.updateLocation(location);
        if (this.audioChannel != null) {
            this.audioChannel.updateLocation(CommonRadioPlugin.serverApi.createPosition((double)location.x, (double)location.y, (double)location.z));
        }
    }

    @Override
    public void tick(int tickCount) {
        super.tick(tickCount);
        if (this.speakingTime > 0) {
            --this.speakingTime;
        }
    }

    @Override
    public void accept(RadioSource source) {
        if (!this.active) {
            return;
        }
        if (this.acceptCriteria != null && !this.acceptCriteria.test(source)) {
            return;
        }
        super.accept(source);
        this.speak(source);
    }

    public void speak(RadioSource source) {
        this.compileActivity(source);
        ServerLevel level = null;
        Vector3f position = null;
        if (this.location != null) {
            level = (ServerLevel)this.location.level;
            position = this.location.position();
        } else {
            level = (ServerLevel)this.owner.m_9236_();
            position = this.owner.m_20182_().m_252839_();
        }
        if (level == null || position == null) {
            return;
        }
        if (!SimpleRadioLibrary.SERVER_CONFIG.frequency.crossDimensional.booleanValue() && level != source.origin.level) {
            return;
        }
        this.effect.severity = (float)source.computeSeverity();
        this.effect.volume = source.volume;
        if (this.effect.severity >= 100.0f) {
            return;
        }
        if (source.data == null) {
            if (source.soundEvent == null) {
                return;
            }
            for (ServerPlayer player : level.m_6907_()) {
                Vec3 vec3 = new Vec3(position);
                if (!(player.m_20182_().m_82554_(vec3) < 50.0)) continue;
                Services.NETWORKING.sendToPlayer(player, new ClientboundSpeakSoundPacket(this.getReference(), (Holder<SoundEvent>)Holder.m_205709_((Object)source.soundEvent), source.volume, source.pitch, this.effect.severity, source.offset, source.seed));
            }
            return;
        }
        Map listenerPackets = this.packetBuffer.computeIfAbsent(source.owner, k -> new HashMap());
        Queue playerPackets = listenerPackets.computeIfAbsent(source.originalOwner, k -> new LinkedList());
        if (playerPackets.isEmpty()) {
            for (int i = 0; i < SimpleRadioLibrary.SERVER_CONFIG.frequency.packetBuffer; ++i) {
            }
        }
        byte[] data = source.data;
        OpusDecoder decoder = this.getDecoder(source.owner);
        if (data == null || data.length == 0) {
            decoder.resetState();
            return;
        }
        short[] decoded = decoder.decode(data);
        playerPackets.offer(this.effect.apply(decoded));
        Services.COMPAT.onData(this, source, decoded);
        CompatCore.onData(this, source, decoded);
        if (this.audioPlayer == null) {
            this.getAudioPlayer().startPlaying();
        }
    }

    public OpusDecoder getDecoder(UUID sender) {
        return this.decoders.computeIfAbsent(sender, uuid -> CommonRadioPlugin.serverApi.createDecoder());
    }

    private AudioPlayer getAudioPlayer() {
        if (this.audioPlayer == null) {
            WorldlyPosition location = this.getLocation();
            this.audioChannel = CommonRadioPlugin.serverApi.createLocationalAudioChannel(this.reference, CommonRadioPlugin.serverApi.fromServerLevel((Object)location.level), CommonRadioPlugin.serverApi.createPosition((double)location.x + 0.5, (double)location.y + 0.5, (double)location.z + 0.5));
            this.audioChannel.setDistance(this.range);
            this.audioChannel.setCategory(this.category);
            this.audioPlayer = CommonRadioPlugin.serverApi.createAudioPlayer((AudioChannel)this.audioChannel, CommonRadioPlugin.serverApi.createEncoder(), (Supplier)this);
        }
        return this.audioPlayer;
    }

    @Override
    public void invalidate() {
        if (this.audioPlayer != null) {
            this.audioPlayer.stopPlaying();
        }
        super.invalidate();
    }
}

