/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.api.central.Auricular;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface Listening
extends Auricular {
    default public RadioListener startListening(Entity owner, @Nullable UUID id) {
        return this.setupListener(RadioManager.getOrCreateListener(owner, id));
    }

    default public RadioListener startListening(WorldlyPosition location, @Nullable UUID id) {
        return this.setupListener(RadioManager.getOrCreateListener(location, id));
    }

    default public RadioListener setupListener(RadioListener listener) {
        Listening listening = this;
        if (listening instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity blockEntity = (AuditoryBlockEntity)((Object)listening);
            listener.transformer(source -> {
                source.delegate(blockEntity.id);
                return source;
            });
        }
        return listener;
    }

    default public void stopListening(UUID owner, boolean isClient) {
        if (isClient) {
            ClientRadioManager.removeRouter(owner);
        } else {
            RadioManager.removeListener(owner);
        }
    }

    default public void stopListening(WorldlyPosition location) {
        if (location.isClientSide()) {
            ClientRadioManager.removeRouter(location);
        } else {
            RadioManager.removeListener(location);
        }
    }

    default public void stopListening() {
        Listening listening = this;
        if (listening instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity blockEntity = (AuditoryBlockEntity)((Object)listening);
            if (blockEntity.listener != null) {
                this.stopListening(blockEntity.listener.location);
                blockEntity.listener.invalidate();
            }
        }
    }
}

