/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.renderers;

import com.codinglitch.simpleradio.core.registry.blocks.FrequencerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix4f;

public class FrequencerRenderer
implements BlockEntityRenderer<FrequencerBlockEntity> {
    public FrequencerRenderer(BlockEntityRendererProvider.Context context) {
    }

    private void draw(String text, float offset, int color, PoseStack poseStack, MultiBufferSource bufferSource) {
        Minecraft minecraft = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.0f + offset, 0.5f);
        poseStack.m_252781_(minecraft.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Font font = minecraft.f_91062_;
        float f2 = -font.m_92895_(text) / 2;
        font.m_271703_(text, f2, 0.0f, color, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
    }

    public void render(FrequencerBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (!blockEntity.m_58898_()) {
            return;
        }
        if (blockEntity.frequency == null) {
            if (blockEntity.frequencies.isEmpty()) {
                if (blockEntity.listeners.isEmpty()) {
                    this.draw("NO FREQUENCIES", 0.0f, Color.red.getRGB(), poseStack, bufferSource);
                } else {
                    this.draw("Listeners", 0.0f, Color.cyan.getRGB(), poseStack, bufferSource);
                    for (int i = 0; i < blockEntity.listeners.size(); ++i) {
                        this.draw(blockEntity.listeners.get(i), (float)(i + 1) * 0.25f, -1, poseStack, bufferSource);
                    }
                }
            } else {
                this.draw("Frequencies", 0.0f, Color.cyan.getRGB(), poseStack, bufferSource);
                for (int i = 0; i < blockEntity.frequencies.size(); ++i) {
                    this.draw(blockEntity.frequencies.get(i), (float)(i + 1) * 0.25f, -1, poseStack, bufferSource);
                }
            }
            return;
        }
        int color = blockEntity.frequencings.size() == 0 ? Color.red.getRGB() : Color.cyan.getRGB();
        this.draw(blockEntity.frequency.frequency + blockEntity.frequency.modulation.shorthand, 0.0f, color, poseStack, bufferSource);
        for (int i = 0; i < blockEntity.frequencings.size(); ++i) {
            String listener = blockEntity.frequencings.get(i);
            this.draw(listener, (float)(i + 1) * 0.25f, -1, poseStack, bufferSource);
        }
    }
}

