/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Routing;
import com.codinglitch.simpleradio.api.central.Transmitting;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioFrequencing;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.CatalyzingBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.TransmitterBlockEntity;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TransmitterBlock
extends BaseEntityBlock
implements Routing,
Transmitting {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)9.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)12.0, (double)16.0));
    private static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)9.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)1.0, (double)13.0, (double)12.0, (double)15.0));
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)9.0, (double)12.0), (VoxelShape)Block.m_49796_((double)1.0, (double)9.0, (double)0.0, (double)15.0, (double)12.0, (double)13.0));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0), (VoxelShape)Block.m_49796_((double)3.0, (double)9.0, (double)1.0, (double)16.0, (double)12.0, (double)15.0));

    public TransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public RadioTransmitter getOrCreateTransmitter(WorldlyPosition location, Frequency frequency, UUID id, BlockState state) {
        return this.startTransmitting(location, frequency, id).frequencingType(SimpleRadioFrequencing.TRANSMITTER);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder.m_61104_(new Property[]{FACING}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            default -> SHAPE_WEST;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return 0;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity auditoryBlockEntity = (AuditoryBlockEntity)blockEntity;
            auditoryBlockEntity.m_187476_(stack);
        }
        return List.of(stack);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity auditoryBlockEntity = (AuditoryBlockEntity)blockEntity;
            auditoryBlockEntity.loadFromItem(stack);
        }
        super.m_6402_(level, blockPos, blockState, entity, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        CatalyzingBlockEntity catalyzingBlock;
        InteractionResult interactionResult;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return super.m_6227_(state, level, pos, player, hand, result);
        }
        if (blockEntity instanceof CatalyzingBlockEntity && (interactionResult = (catalyzingBlock = (CatalyzingBlockEntity)blockEntity).trySwapCatalyst(state, level, pos, player, hand, result)) != null) {
            return interactionResult;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransmitterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TransmitterBlock.m_152132_(type, SimpleRadioBlockEntities.TRANSMITTER, TransmitterBlockEntity::tick);
    }
}

