/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Transmitting;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.CatalyzingBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.TransmitterBlock;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TransmitterBlockEntity
extends CatalyzingBlockEntity
implements Transmitting {
    public boolean isActive = false;
    public boolean isDirty = true;
    public int antennaPower = 0;

    public TransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.TRANSMITTER, pos, state);
    }

    @Override
    public BlockPos getAdaptorLocation() {
        return this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)TransmitterBlock.FACING)).m_122424_());
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.transmitter != null) {
            this.f_58857_.m_6263_(null, (double)this.transmitter.location.x, (double)this.transmitter.location.y, (double)this.transmitter.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.inactivate();
        super.m_7651_();
    }

    @Override
    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
    }

    @Override
    public void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        tag.m_128405_("antennaPower", this.antennaPower);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
        if (tag.m_128441_("antennaPower")) {
            this.antennaPower = tag.m_128451_("antennaPower");
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, TransmitterBlockEntity blockEntity) {
        if (blockEntity.frequency != null && blockEntity.id != null && !blockEntity.isActive) {
            blockEntity.activate();
        }
        CatalyzingBlockEntity.tick(level, pos, blockState, blockEntity);
        if (blockEntity.transmitter != null) {
            boolean bl = blockEntity.transmitter.active = blockEntity.catalyst != null;
        }
        if (!blockEntity.catalyzed) {
            return;
        }
        if (blockEntity.isDirty && level.m_46467_() % 200L == 0L && !level.f_46443_) {
            blockEntity.antennaPower = blockEntity.calculateAntennaPower(blockEntity.getAdaptorLocation(), level);
            RadioRouter router = blockEntity.getRouter();
            if (router instanceof RadioTransmitter) {
                RadioTransmitter transmitter = (RadioTransmitter)router;
                transmitter.antennaPower = blockEntity.antennaPower;
            }
            level.m_7260_(pos, blockState, blockState, 2);
            blockEntity.m_6596_();
            blockEntity.isDirty = false;
        }
    }

    public void inactivate() {
        if (this.frequency != null) {
            RadioManager.removeRouterSided(this.id, this.f_58857_.f_46443_);
            if (!this.f_58857_.f_46443_) {
                this.stopTransmitting(this.frequency.frequency, this.frequency.modulation, this.id);
            }
        }
        this.isActive = false;
    }

    public void activate() {
        WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_));
        if (!this.f_58857_.f_46443_) {
            this.transmitter = SimpleRadioBlocks.TRANSMITTER.getOrCreateTransmitter(location, this.frequency, this.id, this.m_58900_());
            this.f_58857_.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            this.transmitter = new RadioTransmitter(this.frequency, location, this.id);
            ClientRadioManager.registerRouter(this.transmitter);
        }
        this.isActive = true;
    }

    @Override
    public int getAntennaPower() {
        return this.antennaPower;
    }
}

