/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.api.central.FrequencingType;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class RadioReceiver
extends RadioRouter {
    public int antennaPower = 0;
    public Frequency frequency;
    public FrequencingType frequencingType;

    protected RadioReceiver(Frequency frequency, UUID id) {
        super(id);
        this.setFrequency(frequency);
    }

    protected RadioReceiver(Frequency frequency) {
        this(frequency, UUID.randomUUID());
    }

    public RadioReceiver(Frequency frequency, Entity owner) {
        this(frequency, owner, UUID.randomUUID());
    }

    public RadioReceiver(Frequency frequency, Entity owner, UUID uuid) {
        this(frequency, uuid);
        this.owner = owner;
    }

    public RadioReceiver(Frequency frequency, WorldlyPosition location) {
        this(frequency, location, UUID.randomUUID());
    }

    public RadioReceiver(Frequency frequency, WorldlyPosition location, UUID uuid) {
        this(frequency, uuid);
        this.location = location;
    }

    public void setFrequency(Frequency frequency) {
        if (this.frequency != null) {
            this.frequency.removeReceiver(this);
        }
        this.frequency = frequency;
    }

    public RadioReceiver receiveCriteria(Predicate<RadioSource> criteria) {
        this.acceptCriteria = criteria;
        return this;
    }

    public RadioReceiver frequencingType(FrequencingType type) {
        this.frequencingType = type;
        return this;
    }

    public double getPower() {
        return this.frequencingType.receptionPower + this.antennaPower * this.frequencingType.antennaAptitude;
    }

    @Override
    public void tick(int tickCount) {
        super.tick(tickCount);
    }

    @Override
    @Nullable
    public Frequency getFrequency() {
        return this.frequency;
    }

    @Override
    public void accept(RadioSource source) {
        if (!this.active) {
            return;
        }
        if (this.acceptCriteria != null && !this.acceptCriteria.test(source)) {
            return;
        }
        if (source.transmissionPower <= 0.0f) {
            return;
        }
        this.compileActivity(source);
        this.route(source);
    }
}

