/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SubmarineModel
extends AdvancedEntityModel<SubmarineEntity> {
    private final AdvancedModelBox hull;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox leftpropeller;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rightpropeller;
    private final AdvancedModelBox llever;
    private final AdvancedModelBox rlever;
    private final AdvancedModelBox watermask;
    private final AdvancedModelBox motor;
    private final AdvancedModelBox backpropeller;
    private final AdvancedModelBox periscope;
    private final AdvancedModelBox seat;

    public SubmarineModel() {
        this.texWidth = 512;
        this.texHeight = 512;
        this.hull = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hull.setRotationPoint(0.0f, -10.0f, 0.0f);
        this.hull.setTextureOffset(103, 0).addBox(-8.0f, -26.0f, 7.0f, 16.0f, 6.0f, 16.0f, 0.0f, false);
        this.hull.setTextureOffset(0, 66).addBox(-20.0f, -22.0f, -7.0f, 40.0f, 46.0f, 32.0f, 0.0f, false);
        this.hull.setTextureOffset(152, 161).addBox(13.0f, 8.0f, -30.0f, 7.0f, 16.0f, 23.0f, 0.0f, false);
        this.hull.setTextureOffset(92, 161).addBox(-20.0f, 8.0f, -30.0f, 7.0f, 16.0f, 23.0f, 0.0f, false);
        this.hull.setTextureOffset(154, 0).addBox(-18.0f, -20.0f, -35.0f, 36.0f, 28.0f, 28.0f, 0.0f, false);
        this.hull.setTextureOffset(112, 66).addBox(-20.0f, 8.0f, -37.0f, 40.0f, 16.0f, 7.0f, 0.0f, false);
        this.hull.setTextureOffset(251, 189).addBox(-6.0f, 8.0f, -30.0f, 12.0f, 16.0f, 6.0f, 0.0f, false);
        this.hull.setTextureOffset(0, 0).addBox(-13.0f, 15.0f, -30.0f, 26.0f, 15.0f, 51.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(22.5f, 25.5f, -7.5f);
        this.hull.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(255, 91).addBox(-9.5f, -9.5f, -43.5f, 19.0f, 19.0f, 51.0f, 0.0f, false);
        this.leftpropeller = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftpropeller.setRotationPoint(0.0f, 0.0f, -43.5f);
        this.rarm.addChild((BasicModelPart)this.leftpropeller);
        this.leftpropeller.setTextureOffset(189, 165).addBox(-9.5f, -9.5f, -3.0f, 19.0f, 19.0f, 0.0f, 0.0f, false);
        this.leftpropeller.setTextureOffset(103, 22).addBox(-2.5f, -2.5f, -6.0f, 5.0f, 5.0f, 6.0f, 0.0f, false);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(-22.5f, 25.5f, -25.5f);
        this.hull.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(255, 91).addBox(-9.5f, -9.5f, -25.5f, 19.0f, 19.0f, 51.0f, 0.0f, true);
        this.rightpropeller = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightpropeller.setRotationPoint(0.0f, 0.0f, -25.5f);
        this.larm.addChild((BasicModelPart)this.rightpropeller);
        this.rightpropeller.setTextureOffset(189, 165).addBox(-9.5f, -9.5f, -3.0f, 19.0f, 19.0f, 0.0f, 0.0f, false);
        this.rightpropeller.setTextureOffset(103, 22).addBox(-2.5f, -2.5f, -6.0f, 5.0f, 5.0f, 6.0f, 0.0f, false);
        this.llever = new AdvancedModelBox((AdvancedEntityModel)this);
        this.llever.setRotationPoint(-7.0f, 15.25f, -16.0f);
        this.hull.addChild((BasicModelPart)this.llever);
        this.llever.setTextureOffset(265, 72).addBox(-1.0f, -11.25f, -1.0f, 2.0f, 16.0f, 2.0f, 0.0f, true);
        this.rlever = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rlever.setRotationPoint(7.0f, 15.0f, -16.0f);
        this.hull.addChild((BasicModelPart)this.rlever);
        this.rlever.setTextureOffset(265, 72).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 16.0f, 2.0f, 0.0f, true);
        this.watermask = new AdvancedModelBox((AdvancedEntityModel)this);
        this.watermask.setRotationPoint(0.0f, 5.0f, 0.0f);
        this.hull.addChild((BasicModelPart)this.watermask);
        this.watermask.setTextureOffset(0, 214).addBox(-18.0f, 0.0f, -35.0f, 36.0f, 52.0f, 28.0f, 0.0f, false);
        this.motor = new AdvancedModelBox((AdvancedEntityModel)this);
        this.motor.setRotationPoint(0.0f, 1.0f, 25.0f);
        this.hull.addChild((BasicModelPart)this.motor);
        this.motor.setTextureOffset(0, 0).addBox(-9.0f, -8.0f, 0.0f, 18.0f, 18.0f, 7.0f, 0.0f, false);
        this.motor.setTextureOffset(153, 211).addBox(-14.0f, -13.0f, 7.0f, 28.0f, 28.0f, 18.0f, 0.0f, false);
        this.backpropeller = new AdvancedModelBox((AdvancedEntityModel)this);
        this.backpropeller.setRotationPoint(0.0f, 1.0f, 7.0f);
        this.motor.addChild((BasicModelPart)this.backpropeller);
        this.backpropeller.setTextureOffset(0, 25).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 12.0f, 0.0f, false);
        this.backpropeller.setTextureOffset(0, 188).addBox(-13.0f, -13.0f, 9.0f, 26.0f, 26.0f, 0.0f, 0.0f, false);
        this.periscope = new AdvancedModelBox((AdvancedEntityModel)this);
        this.periscope.setRotationPoint(0.0f, -22.0f, 3.0f);
        this.hull.addChild((BasicModelPart)this.periscope);
        this.periscope.setTextureOffset(0, 66).addBox(-3.0f, -20.0f, -3.0f, 6.0f, 20.0f, 6.0f, 0.0f, false);
        this.periscope.setTextureOffset(199, 59).addBox(-3.0f, -20.0f, -10.0f, 6.0f, 6.0f, 7.0f, 0.25f, false);
        this.periscope.setTextureOffset(103, 35).addBox(-3.0f, -20.0f, -10.0f, 6.0f, 6.0f, 7.0f, 0.0f, false);
        this.seat = new AdvancedModelBox((AdvancedEntityModel)this);
        this.seat.setRotationPoint(0.0f, 13.5f, -11.0f);
        this.hull.addChild((BasicModelPart)this.seat);
        this.seat.setTextureOffset(165, 93).addBox(-4.0f, -1.5f, -4.0f, 8.0f, 3.0f, 8.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.hull);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.hull, (Object)this.rarm, (Object)this.larm, (Object)this.seat, (Object)this.leftpropeller, (Object)this.rightpropeller, (Object)this.llever, (Object)this.rlever, (Object)this.watermask, (Object)this.motor, (Object)this.backpropeller, (Object)this.periscope, (Object[])new AdvancedModelBox[0]);
    }

    public AdvancedModelBox getWaterMask() {
        return this.watermask;
    }

    public void setupAnim(SubmarineEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float leftPropellerRot = Mth.m_14177_((float)entity.getLeftPropellerRot(partialTicks));
        float rightPropellerRot = Mth.m_14177_((float)entity.getRightPropellerRot(partialTicks));
        float backPropellerRot = Mth.m_14177_((float)entity.getBackPropellerRot(partialTicks));
        float shake = Math.max((float)entity.shakeTime - partialTicks, 0.0f) / 10.0f;
        Entity controllingPlayer = entity.m_146895_();
        this.rightpropeller.rotateAngleZ = (float)((double)this.rightpropeller.rotateAngleZ + Math.toRadians(leftPropellerRot));
        this.leftpropeller.rotateAngleZ = (float)((double)this.leftpropeller.rotateAngleZ + Math.toRadians(rightPropellerRot));
        this.backpropeller.rotateAngleZ = (float)((double)this.backpropeller.rotateAngleZ + Math.toRadians(backPropellerRot));
        if (controllingPlayer instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)controllingPlayer;
            float subYaw = 180.0f - entity.m_5675_(partialTicks);
            float headYaw = 180.0f + (living.f_20886_ + (living.m_6080_() - living.f_20886_) * partialTicks);
            this.periscope.rotateAngleY = (float)((double)this.periscope.rotateAngleY + Math.toRadians(subYaw + headYaw));
        }
        this.hull.rotateAngleX = (float)((double)this.hull.rotateAngleX + Math.sin(ageInTicks * 0.7f + 1.0f) * (double)shake * (double)0.05f);
        this.hull.rotateAngleZ = (float)((double)this.hull.rotateAngleZ + Math.sin(ageInTicks * 0.7f) * (double)shake * (double)0.1f);
        if (entity.getDamageLevel() < 4) {
            this.rarm.showModel = true;
        } else {
            this.hull.rotateAngleZ = (float)((double)this.hull.rotateAngleZ + Math.toRadians(10.0));
            this.rarm.showModel = false;
        }
    }

    public void setupWaterMask(SubmarineEntity entity, float partialTicks) {
        float xRot = (float)Math.toRadians(-entity.m_5686_(partialTicks));
        Vec3 vec3 = new Vec3(0.0, (double)entity.getWaterHeight(), 0.0).m_82496_(xRot);
        this.watermask.rotateAngleX = this.hull.rotateAngleX;
        this.watermask.rotateAngleZ = this.hull.rotateAngleZ;
        this.watermask.rotationPointY -= 7.0f;
        this.watermask.setScale(1.0f, 0.25f, 1.0f);
    }
}

