/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.ForsakenModel;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.ForsakenHeldMobLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class ForsakenRenderer
extends MobRenderer<ForsakenEntity, ForsakenModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/forsaken.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexscaves:textures/entity/forsaken_eyes.png");
    private static final ResourceLocation TEXTURE_DARKNESS = new ResourceLocation("alexscaves:textures/entity/forsaken_darkness.png");
    private static final HashMap<Integer, Vec3> mouthParticlePositions = new HashMap();

    public ForsakenRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ForsakenModel(), 1.15f);
        this.m_115326_(new LayerGlow());
        this.m_115326_(new ForsakenHeldMobLayer(this));
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack poseStack, int renderTick, Camera camera, float partialTick) {
        mouthParticlePositions.clear();
    }

    public void render(ForsakenEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
        mouthParticlePositions.put(entity.m_19879_(), ((ForsakenModel)this.f_115290_).getMouthPosition(Vec3.f_82478_));
    }

    public static Vec3 getMouthPositionFor(int entityId) {
        return mouthParticlePositions.get(entityId);
    }

    public ResourceLocation getTextureLocation(ForsakenEntity entity) {
        return TEXTURE;
    }

    class LayerGlow
    extends RenderLayer<ForsakenEntity, ForsakenModel> {
        public LayerGlow() {
            super((RenderLayerParent)ForsakenRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, ForsakenEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer darnkessConsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_DARKNESS));
            ((ForsakenModel)this.m_117386_()).m_7695_(matrixStackIn, darnkessConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, entitylivingbaseIn.getDarknessAmount(partialTicks));
            VertexConsumer eyesConsumer = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_EYES));
            ((ForsakenModel)this.m_117386_()).m_7695_(matrixStackIn, eyesConsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

