/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin.client;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.sound.NuclearExplosionSound;
import com.github.alexmodguy.alexscaves.client.sound.UnlimitedPitch;
import java.util.Map;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin {
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> f_120226_;
    private float lastNukeSoundDampenBy = 0.0f;

    @Shadow
    protected abstract float m_120327_(SoundInstance var1);

    @Inject(method={"Lnet/minecraft/client/sounds/SoundEngine;calculatePitch(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void ac_calculatePitch(SoundInstance soundInstance, CallbackInfoReturnable<Float> cir) {
        if (soundInstance instanceof UnlimitedPitch) {
            cir.setReturnValue((Object)Float.valueOf(soundInstance.m_7783_()));
        }
    }

    @Inject(method={"Lnet/minecraft/client/sounds/SoundEngine;calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void ac_calculateVolume(SoundInstance soundInstance, CallbackInfoReturnable<Float> cir) {
        if (!(soundInstance instanceof NuclearExplosionSound) && ClientProxy.masterVolumeNukeModifier > 0.0f && ((Boolean)AlexsCaves.CLIENT_CONFIG.nuclearBombMufflesSounds.get()).booleanValue()) {
            float f = Math.max(1.0f - ClientProxy.masterVolumeNukeModifier, 0.01f);
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * f));
        }
    }

    @Inject(method={"Lnet/minecraft/client/sounds/SoundEngine;tickNonPaused()V"}, at={@At(value="TAIL")})
    private void ac_tickNonPaused(CallbackInfo ci) {
        if ((this.lastNukeSoundDampenBy != ClientProxy.masterVolumeNukeModifier || ClientProxy.masterVolumeNukeModifier > 0.0f) && ((Boolean)AlexsCaves.CLIENT_CONFIG.nuclearBombMufflesSounds.get()).booleanValue()) {
            this.dampenSoundsFromNuke();
        }
    }

    public void dampenSoundsFromNuke() {
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : this.f_120226_.entrySet()) {
            ChannelAccess.ChannelHandle channelHandle = entry.getValue();
            SoundInstance soundinstance = entry.getKey();
            float f = this.m_120327_(soundinstance);
            channelHandle.m_120154_(sound -> sound.m_83666_(f));
        }
        this.lastNukeSoundDampenBy = ClientProxy.masterVolumeNukeModifier;
    }
}

