/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.LunchBoxItem;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.items.SafeItem;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryTooltip;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkClientCompat;
import net.mehvahdjukaar.supplementaries.integration.ShulkerBoxTooltipCompat;
import net.mehvahdjukaar.supplementaries.integration.forge.InventoryTooltipComponent;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import org.violetmoon.quark.api.event.UsageTickerEvent;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class QuarkClientCompatImpl {
    private static final Supplier<SafeBlockTile> DUMMY_SAFE_TILE = Suppliers.memoize(() -> new SafeBlockTile(BlockPos.f_121853_, ModRegistry.SAFE.get().m_49966_()));

    public static void initClient() {
        ClientHelper.addBlockEntityRenderersRegistration(QuarkClientCompat::registerEntityRenderers);
        MinecraftForge.EVENT_BUS.addListener(QuarkClientCompatImpl::onItemTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(QuarkClientCompatImpl::usageTickerCount);
        MinecraftForge.EVENT_BUS.addListener(QuarkClientCompatImpl::usageTickerStack);
        ClientHelper.addTooltipComponentRegistration(QuarkClientCompatImpl::registerTooltipComponent);
    }

    public static void registerTooltipComponent(ClientHelper.TooltipComponentEvent event) {
        event.register(InventoryTooltip.class, InventoryTooltipComponent::new);
    }

    public static void onItemTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        Item item;
        boolean sbtTooltip;
        ItemStack stack = event.getItemStack();
        boolean quarkTooltip = QuarkClientCompat.canRenderQuarkTooltip();
        boolean bl = sbtTooltip = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(stack);
        if (quarkTooltip && !sbtTooltip && ((item = stack.m_41720_()) instanceof SafeItem || item instanceof SackItem)) {
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)false);
            if (cmp.m_128441_("LootTable")) {
                return;
            }
            if (item instanceof SafeItem) {
                DUMMY_SAFE_TILE.get().m_142466_(cmp);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && !DUMMY_SAFE_TILE.get().canPlayerOpen((Player)Minecraft.m_91087_().f_91074_, false)) {
                    return;
                }
            }
            List tooltip = event.getTooltipElements();
            ArrayList tooltipCopy = new ArrayList(tooltip);
            for (int i = 1; i < tooltipCopy.size(); ++i) {
                String s;
                Either either = (Either)tooltipCopy.get(i);
                if (!either.left().isPresent() || (s = ((FormattedText)either.left().get()).getString()).startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                tooltip.remove(either);
            }
            if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.m_96638_()) {
                tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.shulker_box_shift")));
            }
        }
    }

    public static void usageTickerStack(UsageTickerEvent.GetStack event) {
        Item item = event.currentRealStack.m_41720_();
        if (item instanceof LunchBoxItem) {
            LunchBoxItem li = (LunchBoxItem)item;
            LunchBoxItem.Data data = li.getData(event.currentRealStack);
            event.setResultStack(data.getSelected());
        }
    }

    public static void usageTickerCount(UsageTickerEvent.GetCount event) {
        ItemStack selected;
        QuiverItem.Data data;
        IQuiverEntity qe;
        ItemStack q;
        Player player;
        Item item = event.currentRealStack.m_41720_();
        if (item instanceof LunchBoxItem) {
            LunchBoxItem li = (LunchBoxItem)item;
            LunchBoxItem.Data data2 = li.getData(event.currentRealStack);
            event.setResultCount(data2.getSelectedItemCount());
        } else if (event.currentRealStack.m_41720_() instanceof ProjectileWeaponItem && event.currentStack != event.currentRealStack && (player = event.player) instanceof IQuiverEntity && !(q = (qe = (IQuiverEntity)player).supplementaries$getQuiver()).m_41619_() && (data = QuiverItem.getQuiverData(q)) != null && event.currentStack.m_150930_((selected = data.getSelected()).m_41720_())) {
            int count = data.getSelectedItemCount();
            Inventory inventory = event.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stackAt = inventory.m_8020_(i);
                if (!selected.m_150930_(stackAt.m_41720_())) continue;
                count += stackAt.m_41613_();
            }
            event.setResultCount(count);
        }
    }
}

