/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyInstance;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class CarriageBogey {
    public static final String UPSIDE_DOWN_KEY = "UpsideDown";
    public Carriage carriage;
    boolean isLeading;
    public CompoundTag bogeyData;
    AbstractBogeyBlock<?> type;
    boolean upsideDown;
    Couple<TravellingPoint> points;
    LerpedFloat wheelAngle;
    LerpedFloat yaw;
    LerpedFloat pitch;
    public Couple<Vec3> couplingAnchors;
    int derailAngle;

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, CompoundTag bogeyData, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        point.upsideDown = this.upsideDown = type.canBeUpsideDown() && upsideDown;
        point2.upsideDown = this.upsideDown;
        if (bogeyData == null || bogeyData.m_128456_()) {
            bogeyData = this.createBogeyData();
        }
        bogeyData.m_128379_(UPSIDE_DOWN_KEY, upsideDown);
        this.bogeyData = bogeyData;
        this.points = Couple.create(point, point2);
        this.wheelAngle = LerpedFloat.angular();
        this.yaw = LerpedFloat.angular();
        this.pitch = LerpedFloat.angular();
        this.derailAngle = Create.RANDOM.nextInt(60) - 30;
        this.couplingAnchors = Couple.create(null, null);
    }

    public ResourceKey<Level> getDimension() {
        TravellingPoint leading = this.leading();
        TravellingPoint trailing = this.trailing();
        if (leading.edge == null || trailing.edge == null) {
            return null;
        }
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional()) {
            return null;
        }
        ResourceKey<Level> dimension1 = leading.node1.getLocation().dimension;
        ResourceKey<Level> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2)) {
            return dimension1;
        }
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360.0 * distanceMoved / (Math.PI * 2 * this.type.getWheelRadius());
        float xRot = 0.0f;
        float yRot = 0.0f;
        if (this.leading().edge == null || this.carriage.train.derailed) {
            yRot = -90.0f + entity.yaw - (float)this.derailAngle;
        } else if (!entity.m_9236_().m_46472_().equals(this.getDimension())) {
            yRot = -90.0f + entity.yaw;
            xRot = 0.0f;
        } else {
            Vec3 positionVec = this.leading().getPosition(this.carriage.train.graph);
            Vec3 coupledVec = this.trailing().getPosition(this.carriage.train.graph);
            double diffX = positionVec.f_82479_ - coupledVec.f_82479_;
            double diffY = positionVec.f_82480_ - coupledVec.f_82480_;
            double diffZ = positionVec.f_82481_ - coupledVec.f_82481_;
            yRot = AngleHelper.deg(Mth.m_14136_((double)diffZ, (double)diffX)) + 90.0f;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }
        double newWheelAngle = ((double)this.wheelAngle.getValue() - angleDiff) % 360.0;
        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate) continue;
            this.wheelAngle.setValue(newWheelAngle);
            this.pitch.setValue(xRot);
            this.yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        TravellingPoint point = (TravellingPoint)this.points.getFirst();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public TravellingPoint trailing() {
        TravellingPoint point = (TravellingPoint)this.points.getSecond();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public double getStress() {
        if (this.getDimension() == null) {
            return 0.0;
        }
        if (this.carriage.train.derailed) {
            return 0.0;
        }
        return this.type.getWheelPointSpacing() - this.leading().getPosition(this.carriage.train.graph).m_82554_(this.trailing().getPosition(this.carriage.train.graph));
    }

    @Nullable
    public Vec3 getAnchorPosition() {
        return this.getAnchorPosition(false);
    }

    @Nullable
    public Vec3 getAnchorPosition(boolean flipUpsideDown) {
        if (this.leading().edge == null) {
            return null;
        }
        return ((TravellingPoint)this.points.getFirst()).getPosition(this.carriage.train.graph, flipUpsideDown).m_82549_(((TravellingPoint)this.points.getSecond()).getPosition(this.carriage.train.graph, flipUpsideDown)).m_82490_(0.5);
    }

    public void updateCouplingAnchor(Vec3 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float partialTicks, boolean leading) {
        boolean selfUpsideDown = this.isUpsideDown();
        boolean leadingUpsideDown = this.carriage.leadingBogey().isUpsideDown();
        Vec3 thisOffset = this.type.getConnectorAnchorOffset(selfUpsideDown);
        thisOffset = thisOffset.m_82542_(1.0, 1.0, leading ? -1.0 : 1.0);
        thisOffset = VecHelper.rotate(thisOffset, this.pitch.getValue(partialTicks), Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, this.yaw.getValue(partialTicks), Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90.0f, Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, -180.0, Direction.Axis.Y);
        thisOffset = thisOffset.m_82520_(0.0, 0.0, leading ? 0.0 : (double)(-bogeySpacing));
        thisOffset = VecHelper.rotate(thisOffset, 180.0, Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90.0f, Direction.Axis.Y);
        if (selfUpsideDown != leadingUpsideDown) {
            thisOffset = thisOffset.m_82520_(0.0, selfUpsideDown ? -2.0 : 2.0, 0.0);
        }
        this.couplingAnchors.set(leading, entityPos.m_82549_(thisOffset));
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", RegisteredObjects.getKeyOrThrow(this.type).toString());
        tag.m_128365_("Points", (Tag)this.points.serializeEach(tp -> tp.write(dimensions)));
        tag.m_128379_(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.m_128379_(UPSIDE_DOWN_KEY, this.upsideDown);
        NBTHelper.writeResourceLocation(this.bogeyData, "BogeyStyle", this.getStyle().name);
        tag.m_128365_("BogeyData", (Tag)this.bogeyData);
        return tag;
    }

    public static CarriageBogey read(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions) {
        ResourceLocation location = new ResourceLocation(tag.m_128461_("Type"));
        AbstractBogeyBlock type = (AbstractBogeyBlock)ForgeRegistries.BLOCKS.getValue(location);
        boolean upsideDown = tag.m_128471_(UPSIDE_DOWN_KEY);
        Couple<TravellingPoint> points = Couple.deserializeEach(tag.m_128437_("Points", 10), c -> TravellingPoint.read(c, graph, dimensions));
        CompoundTag data = tag.m_128469_("BogeyData");
        return new CarriageBogey(type, upsideDown, data, (TravellingPoint)points.getFirst(), (TravellingPoint)points.getSecond());
    }

    public BogeyInstance createInstance(MaterialManager materialManager) {
        return this.getStyle().createInstance(this, this.type.getSize(), materialManager);
    }

    public BogeyStyle getStyle() {
        ResourceLocation location = NBTHelper.readResourceLocation(this.bogeyData, "BogeyStyle");
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(location);
        return style != null ? style : AllBogeyStyles.STANDARD;
    }

    private CompoundTag createBogeyData() {
        BogeyStyle style = this.type != null ? this.type.getDefaultStyle() : AllBogeyStyles.STANDARD;
        CompoundTag nbt = style.defaultData != null ? style.defaultData : new CompoundTag();
        NBTHelper.writeResourceLocation(nbt, "BogeyStyle", style.name);
        nbt.m_128379_(UPSIDE_DOWN_KEY, this.isUpsideDown());
        return nbt;
    }

    void setLeading() {
        this.isLeading = true;
    }

    public boolean isUpsideDown() {
        return this.type.canBeUpsideDown() && this.upsideDown;
    }
}

