/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.mod.IBlockSpritesProxy;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.ui.GuiHooks;
import journeymap.common.Journeymap;
import journeymap.common.accessors.FluidAccess;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.apache.logging.log4j.Logger;

public class VanillaBlockSpriteProxy
implements IBlockSpritesProxy,
FluidAccess {
    private static Logger logger = Journeymap.getLogger();
    BlockModelShaper bms = Minecraft.m_91087_().m_91289_().m_110907_();

    @Override
    @Nullable
    public Collection<ColoredSprite> getSprites(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        BlockState blockState = blockMD.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlock) {
            ResourceLocation loc = IClientFluidTypeExtensions.of((FluidType)this.getFluid(blockMD.getBlock()).getFluidType()).getStillTexture();
            TextureAtlasSprite tas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(loc);
            return Collections.singletonList(new ColoredSprite(tas, null));
        }
        if (blockState.m_61147_().contains(DoublePlantBlock.f_52858_)) {
            blockState = (BlockState)blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
        }
        HashMap<String, ColoredSprite> map = new HashMap<String, ColoredSprite>();
        try {
            BakedModel model = this.bms.m_110893_(blockState);
            block2: for (BlockState state : new BlockState[]{blockState, null}) {
                for (Direction facing : new Direction[]{Direction.UP, null}) {
                    if (this.getSprites(blockMD, model, state, facing, map, chunkMD, blockPos)) break block2;
                }
            }
            if (map.isEmpty()) {
                TextureAtlasSprite defaultSprite = this.bms.m_110882_(blockState);
                if (defaultSprite != null) {
                    map.put(defaultSprite.m_245424_().m_246162_().m_135815_(), new ColoredSprite(defaultSprite, null));
                    if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                        logger.debug(String.format("Resorted to using BlockModelStates.getTexture() to use %s as color for %s", defaultSprite.m_245424_().m_246162_().m_135815_(), blockState));
                    }
                } else {
                    logger.warn(String.format("Unable to get any texture to use as color for %s", blockState));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error during getSprites(): " + BuiltInRegistries.f_256975_.m_7981_((Object)blockMD.getBlock()) + " - " + LogFormatter.toPartialString(e));
        }
        return map.values();
    }

    private boolean getSprites(BlockMD blockMD, BakedModel model, @Nullable BlockState blockState, @Nullable Direction facing, HashMap<String, ColoredSprite> map, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        boolean success;
        block7: {
            if (blockPos != null && chunkMD != null && chunkMD.getWorld() != null) {
                try {
                    blockState = chunkMD.getWorld().m_8055_(blockPos);
                    model = this.bms.m_110893_(blockState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            success = false;
            try {
                for (RenderType type : RenderType.m_110506_()) {
                    List quads;
                    if (!RenderShape.MODEL.equals((Object)blockMD.getBlockState().m_60799_()) || !this.addSprites(map, quads = model.getQuads(blockState, facing, RandomSource.m_216327_(), GuiHooks.getModelData(blockPos), type))) continue;
                    if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                        logger.debug(String.format("Success during [%s] %s.getQuads(%s, %s, %s)", type, model.getClass(), blockState, facing, 0));
                    }
                    success = true;
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.error(String.format("Error during [] %s.getQuads(%s, %s, %s): %s", model.getClass(), blockState, facing, 0, LogFormatter.toPartialString(e)));
            }
        }
        return success;
    }

    public boolean addSprites(HashMap<String, ColoredSprite> sprites, List<BakedQuad> quads) {
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        if (quads.size() > 1) {
            HashSet<BakedQuad> culled = new HashSet<BakedQuad>(quads.size());
            culled.addAll(quads);
            quads = new ArrayList<BakedQuad>(culled);
        }
        boolean added = false;
        for (BakedQuad quad : quads) {
            ResourceLocation resourceLocation;
            String iconName;
            TextureAtlasSprite sprite = quad.m_173410_();
            if (sprite == null || sprites.containsKey(iconName = sprite.m_245424_().m_246162_().m_135815_()) || (resourceLocation = new ResourceLocation(iconName)).equals((Object)new ResourceLocation("missingno"))) continue;
            sprites.put(iconName, new ColoredSprite(quad));
            added = true;
        }
        return added;
    }
}

